/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.ClassUtils;
import com.alibaba.ageiport.common.utils.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public final class Version {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
    private static final String VERSION = Version.getVersion(Version.class, "");

    private Version() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        try {
            CodeSource codeSource;
            Package pkg = cls.getPackage();
            String version = null;
            if (pkg != null) {
                version = pkg.getImplementationVersion();
                if (StringUtils.isNotEmpty(version)) {
                    return version;
                }
                version = pkg.getSpecificationVersion();
                if (StringUtils.isNotEmpty(version)) {
                    return version;
                }
            }
            if ((codeSource = cls.getProtectionDomain().getCodeSource()) == null) {
                LOGGER.info("No codeSource for class " + cls.getName() + " when getVersion, use default version " + defaultVersion);
                return defaultVersion;
            }
            String file = codeSource.getLocation().getFile();
            if (!StringUtils.isEmpty(file) && file.endsWith(".jar")) {
                version = Version.getFromFile(file);
            }
            return StringUtils.isEmpty(version) ? defaultVersion : version;
        }
        catch (Throwable e) {
            LOGGER.error("return default version, ignore exception " + e.getMessage(), e);
            return defaultVersion;
        }
    }

    private static String getFromFile(String file) {
        int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
        if (i >= 0) {
            file = file.substring(i + 1);
        }
        if ((i = file.indexOf("-")) >= 0) {
            file = file.substring(i + 1);
        }
        while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
            file = file.substring(i + 1);
        }
        return file;
    }

    public static void checkDuplicate(Class<?> cls, boolean failOnError) {
        Version.checkDuplicate(cls.getName().replace('.', '/') + ".class", failOnError);
    }

    public static void checkDuplicate(Class<?> cls) {
        Version.checkDuplicate(cls, false);
    }

    public static void checkDuplicate(String path, boolean failOnError) {
        try {
            Set<String> files = Version.getResources(path);
            if (files.size() > 1) {
                String error = "Duplicate class " + path + " in " + files.size() + " jar " + files;
                if (failOnError) {
                    throw new IllegalStateException(error);
                }
                LOGGER.error(error);
            }
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    private static Set<String> getResources(String path) throws IOException {
        Enumeration<URL> urls = ClassUtils.getCallerClassLoader(Version.class).getResources(path);
        HashSet<String> files = new HashSet<String>();
        while (urls.hasMoreElements()) {
            String file;
            URL url = urls.nextElement();
            if (url == null || !StringUtils.isNotEmpty(file = url.getFile())) continue;
            files.add(file);
        }
        return files;
    }

    static {
        Version.checkDuplicate(Version.class);
    }
}

