/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.utils;

import com.alibaba.ageiport.common.exception.UtilException;
import com.alibaba.ageiport.common.function.Filter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public final class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static boolean isEmpty(Object array) {
        if (null == array) {
            return true;
        }
        if (ArrayUtils.isArray(array)) {
            return 0 == Array.getLength(array);
        }
        throw new UtilException("Object to provide is not a Array !");
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayUtils.isNotEmpty(array)) {
            for (T element : array) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean notHasNull(T ... array) {
        return !ArrayUtils.hasNull(array);
    }

    public static <T> T[] of(T ... values) {
        return values;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static <T> T[] filter(T[] array, Filter<T> filter) {
        if (null == filter) {
            return array;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            if (!filter.accept(t)) continue;
            list.add(t);
        }
        T[] result = ArrayUtils.newArray(array.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtils.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayUtils.insert(buffer, buffer.length, newElements);
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return (Object[])ArrayUtils.insert(buffer, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ArrayUtils.isEmpty(newElements)) {
            return array;
        }
        if (ArrayUtils.isEmpty(array)) {
            return newElements;
        }
        int len = ArrayUtils.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = ArrayUtils.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static int length(Object array) {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static boolean contains(char[] array, char value) {
        return ArrayUtils.indexOf(array, value) > -1;
    }

    public static int indexOf(char[] array, char value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayUtils.indexOf(array, value) > -1;
    }

    public static <T> int indexOf(T[] array, Object value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (!Objects.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtils.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }
}

