/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.utils;

import com.alibaba.ageiport.common.utils.ArrayUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class CollectionUtils {
    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        int i = 0;
        for (T t : collection) {
            if (i > index) break;
            if (i == index) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        return CollectionUtils.toList(values);
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return (ArrayList)CollectionUtils.list(false, values);
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return CollectionUtils.list(isLinked, new Object[0]);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        return CollectionUtils.set(false, ts);
    }

    @SafeVarargs
    public static <T> HashSet<T> set(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, ts);
        return set;
    }
}

