/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.demo.file.rule;

import com.alibaba.csp.sentinel.datasource.ConfigParser;
import com.alibaba.csp.sentinel.datasource.FileRefreshableDataSource;
import com.alibaba.csp.sentinel.demo.file.rule.FlowQpsRunner;
import com.alibaba.csp.sentinel.demo.file.rule.parser.JsonDegradeRuleListParser;
import com.alibaba.csp.sentinel.demo.file.rule.parser.JsonFlowRuleListParser;
import com.alibaba.csp.sentinel.demo.file.rule.parser.JsonSystemRuleListParser;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;

public class FileDataSourceDemo {
    public static void main(String[] args) throws Exception {
        FileDataSourceDemo demo = new FileDataSourceDemo();
        demo.listenRules();
        FlowQpsRunner runner = new FlowQpsRunner();
        runner.simulateTraffic();
        runner.tick();
    }

    public void listenRules() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String flowRulePath = classLoader.getResource("FlowRule.json").getFile();
        String degradeRulePath = classLoader.getResource("DegradeRule.json").getFile();
        String systemRulePath = classLoader.getResource("SystemRule.json").getFile();
        FileRefreshableDataSource flowRuleDataSource = new FileRefreshableDataSource(flowRulePath, (ConfigParser)new JsonFlowRuleListParser());
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
        FileRefreshableDataSource degradeRuleDataSource = new FileRefreshableDataSource(degradeRulePath, (ConfigParser)new JsonDegradeRuleListParser());
        DegradeRuleManager.register2Property((SentinelProperty)degradeRuleDataSource.getProperty());
        FileRefreshableDataSource systemRuleDataSource = new FileRefreshableDataSource(systemRulePath, (ConfigParser)new JsonSystemRuleListParser());
        SystemRuleManager.register2Property((SentinelProperty)systemRuleDataSource.getProperty());
    }
}

