/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.support;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.cluster.Cluster;
import com.alibaba.dubbo.rpc.cluster.Directory;
import com.alibaba.dubbo.rpc.cluster.LoadBalance;
import com.alibaba.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchCluster
implements Cluster {
    private static final Logger logger = LoggerFactory.getLogger(SwitchCluster.class);
    public static final String NAME = "switch";

    static <T> boolean isConnectedInvoker(Invoker<T> invoker) {
        return invoker.getUrl().getParameter("connected", true);
    }

    static <T> int getInvokerCount(Invoker<T> invoker) {
        return invoker.getUrl().getParameter("inside.invoker.count", 1);
    }

    static <T> List<Invoker<T>> getEffectiveInvokers(List<Invoker<T>> invokers) {
        ArrayList<Invoker<T>> availableInvokers = new ArrayList<Invoker<T>>();
        ArrayList<Invoker<T>> availableAndConnectedInvokers = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : invokers) {
            if (!invoker.isAvailable()) continue;
            if (SwitchCluster.isConnectedInvoker(invoker)) {
                availableAndConnectedInvokers.add(invoker);
            }
            availableInvokers.add(invoker);
        }
        ArrayList<Invoker<T>> effectiveInvokers = availableAndConnectedInvokers;
        if (effectiveInvokers.isEmpty()) {
            effectiveInvokers = availableInvokers;
        }
        return effectiveInvokers;
    }

    static <T> Invoker<T> getSuitableInvoker(List<Invoker<T>> invokers, Directory<T> directory) {
        int i;
        if (invokers.isEmpty()) {
            throw new RpcException("No provider available in " + invokers);
        }
        if (invokers.size() == 1) {
            return invokers.get(0);
        }
        double factor = directory.getUrl().getParameter("cluster.switch.factor", 2.0);
        block0: for (i = 0; i < invokers.size(); ++i) {
            Invoker<T> before = invokers.get(i);
            for (int j = i + 1; j < invokers.size(); ++j) {
                Invoker<T> after = invokers.get(j);
                if (factor * (double)SwitchCluster.getInvokerCount(before) <= (double)SwitchCluster.getInvokerCount(after)) continue block0;
            }
        }
        return invokers.get(i);
    }

    @Override
    public <T> Invoker<T> join(Directory<T> directory) throws RpcException {
        return new AbstractClusterInvoker<T>(directory){

            @Override
            public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
                List effectiveInvokers = SwitchCluster.getEffectiveInvokers(invokers);
                Invoker invoker = SwitchCluster.getSuitableInvoker(effectiveInvokers, this.directory);
                if (invoker != invokers.get(0)) {
                    if (this.directory.getUrl().getParameter("cluster.switch.log.error", true)) {
                        if (logger.isErrorEnabled()) {
                            logger.error("SwitchCluster NOT use FIRST invoker " + invokers.get(0) + " of invoker list " + invokers);
                        }
                    } else if (logger.isWarnEnabled()) {
                        logger.error("SwitchCluster NOT use FIRST invoker " + invokers.get(0) + " of invoker list " + invokers);
                    }
                }
                return invoker.invoke(invocation);
            }
        };
    }
}

