/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.lindorm.sql.ce.search;

import com.alibaba.lindorm.sql.se.search.SimpleSearchDriver;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DecimalModule;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.ForBaseJdbc;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.credential.CredentialProvider;

import java.sql.SQLException;
import java.util.Properties;

public class LindormSearchClientModule implements Module {
  @Override
  public void configure(Binder binder) {
    binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class)
        .to(LindormSearchClient.class).in(Scopes.SINGLETON);
    binder.install(new DecimalModule());
  }

  @Provides
  @Singleton
  @ForBaseJdbc
  public static ConnectionFactory createConnectionFactory(BaseJdbcConfig config,
      CredentialProvider credentialProvider) throws SQLException {
    Properties connectionProperties = new Properties();

    return new DriverConnectionFactory(new SimpleSearchDriver(),
        config.getConnectionUrl(), connectionProperties, credentialProvider);
  }
}
