/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.lindorm.sql.se.search;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class SearchConnection implements Connection {
  private Connection calciteConnection = null;

  public SearchConnection(Connection connection) {
    this.calciteConnection = connection;
  }

  @Override
  public Statement createStatement() throws SQLException {
    return new SearchStatement(calciteConnection);
  }

  @Override
  public PreparedStatement prepareStatement(String sql) throws SQLException {
    try {
      String tmpStr = sql;
      int num = 0;
      while (true) {
        int pos = tmpStr.indexOf("?");
        if (pos != -1) {
          num++;
        } else {
          break;
        }
        if (tmpStr.length() > pos + 1) {
          tmpStr = tmpStr.substring(pos + 1);
        } else {
          break;
        }
      }
      return new SearchPreparedStatement(this, sql, num);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public CallableStatement prepareCall(String sql) throws SQLException {
    try {
      return calciteConnection.prepareCall(sql);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public String nativeSQL(String sql) throws SQLException {
    try {
      return calciteConnection.nativeSQL(sql);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void setAutoCommit(boolean autoCommit) throws SQLException {
    try {
      calciteConnection.setAutoCommit(autoCommit);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public boolean getAutoCommit() throws SQLException {
    try {
      return calciteConnection.getAutoCommit();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void commit() throws SQLException {
    try {
      calciteConnection.commit();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void rollback() throws SQLException {
    try {
      calciteConnection.rollback();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void close() throws SQLException {
    try {
      calciteConnection.close();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public boolean isClosed() throws SQLException {
    try {
      return calciteConnection.isClosed();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public DatabaseMetaData getMetaData() throws SQLException {
    try {
      return calciteConnection.getMetaData();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void setReadOnly(boolean readOnly) throws SQLException {
    try {
      calciteConnection.setReadOnly(readOnly);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public boolean isReadOnly() throws SQLException {
    try {
      return calciteConnection.isReadOnly();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void setCatalog(String catalog) throws SQLException {
    try {
      calciteConnection.setCatalog(catalog);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public String getCatalog() throws SQLException {
    try {
      return calciteConnection.getCatalog();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void setTransactionIsolation(int level) throws SQLException {
    try {
      calciteConnection.setTransactionIsolation(level);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public int getTransactionIsolation() throws SQLException {
    try {
      return calciteConnection.getTransactionIsolation();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public SQLWarning getWarnings() throws SQLException {
    try {
      return calciteConnection.getWarnings();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void clearWarnings() throws SQLException {
    try {
      calciteConnection.clearWarnings();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
    try {
      return calciteConnection.createStatement(resultSetType, resultSetConcurrency);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
    try {
      return calciteConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
    try {
      return calciteConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public Map<String, Class<?>> getTypeMap() throws SQLException {
    try {
      return calciteConnection.getTypeMap();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    try {
      calciteConnection.setTypeMap(map);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void setHoldability(int holdability) throws SQLException {
    try {
      calciteConnection.setHoldability(holdability);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public int getHoldability() throws SQLException {
    try {
      return calciteConnection.getHoldability();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public Savepoint setSavepoint() throws SQLException {
    try {
      return calciteConnection.setSavepoint();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public Savepoint setSavepoint(String name) throws SQLException {
    try {
      return calciteConnection.setSavepoint(name);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void rollback(Savepoint savepoint) throws SQLException {
    try {
      calciteConnection.rollback(savepoint);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    try {
      calciteConnection.releaseSavepoint(savepoint);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    try {
      return calciteConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    try {
      return calciteConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
    try {
      return calciteConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
    try {
      return calciteConnection.prepareStatement(sql, autoGeneratedKeys);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
    try {
      return calciteConnection.prepareStatement(sql, columnIndexes);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
    try {
      return calciteConnection.prepareStatement(sql, columnNames);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public Clob createClob() throws SQLException {
    try {
      return calciteConnection.createClob();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public Blob createBlob() throws SQLException {
    try {
      return calciteConnection.createBlob();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public NClob createNClob() throws SQLException {
    try {
      return calciteConnection.createNClob();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public SQLXML createSQLXML() throws SQLException {
    try {
      return calciteConnection.createSQLXML();
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public boolean isValid(int timeout) throws SQLException {
    try {
      return calciteConnection.isValid(timeout);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void setClientInfo(String name, String value) throws SQLClientInfoException {
    try {
      calciteConnection.setClientInfo(name, value);
    } catch (Throwable e) {
      throw new SQLClientInfoException();
    }
  }

  @Override
  public void setClientInfo(Properties properties) throws SQLClientInfoException {
    try {
      calciteConnection.setClientInfo(properties);
    } catch (Throwable e) {
      throw new SQLClientInfoException();
    }
  }

  @Override
  public String getClientInfo(String name) throws SQLException {
    return null;
  }

  @Override
  public Properties getClientInfo() throws SQLException {
    return null;
  }

  @Override
  public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
    return null;
  }

  @Override
  public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
    return null;
  }

  @Override
  public void setSchema(String schema) throws SQLException {

  }

  @Override
  public String getSchema() throws SQLException {
    return null;
  }

  @Override
  public void abort(Executor executor) throws SQLException {

  }

  @Override
  public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {

  }

  @Override
  public int getNetworkTimeout() throws SQLException {
    return 0;
  }

  @Override
  public <T> T unwrap(Class<T> iface) throws SQLException {
    return null;
  }

  @Override
  public boolean isWrapperFor(Class<?> iface) throws SQLException {
    return false;
  }
}
