/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.lindorm.sql.se.search;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class SearchStatement implements Statement {
  private Connection connection = null;
  private Statement stmt = null;
  private ResultSet rs = null;
  private boolean isClosed = false;

  public SearchStatement(Connection connection) {
    this.connection = connection;
  }

  @Override
  public boolean execute(String sql) throws SQLException {
    try {
      if (stmt == null) {
        stmt = connection.createStatement();
      }
      if (sql.trim().toUpperCase().startsWith("SELECT")) {
        rs = stmt.executeQuery(sql);
        return true;
      } else {
        stmt.execute(sql);
        return false;
      }
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public ResultSet getResultSet() throws SQLException {
    return rs;
  }

  @Override
  public ResultSet executeQuery(String sql) throws SQLException {
    try {
      if (stmt == null) {
        stmt = connection.createStatement();
      }
      if (sql.trim().toUpperCase().startsWith("SELECT NULL FROM")) {
        sql = "select 1 from " + sql.substring("SELECT NULL FROM".length());
      }
      return stmt.executeQuery(sql);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public int executeUpdate(String sql) throws SQLException {
    try {
      if (stmt == null) {
        stmt = connection.createStatement();
      }
      return stmt.executeUpdate(sql);
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public void close() throws SQLException {
    try {
      if (rs != null) {
        rs.close();
      }
      if (stmt != null) {
        stmt.close();
      }
      isClosed = true;
    } catch (Throwable e) {
      throw new SQLException(e);
    }
  }

  @Override
  public int getMaxFieldSize() throws SQLException {
    throw new SQLException("getMaxFieldSize() not supported");
  }

  @Override
  public void setMaxFieldSize(int max) throws SQLException {
    throw new SQLException("setMaxFieldSize(int max) not supported");
  }

  @Override
  public int getMaxRows() throws SQLException {
    throw new SQLException("getMaxRows() not supported");
  }

  @Override
  public void setMaxRows(int max) throws SQLException {
  }

  @Override
  public void setEscapeProcessing(boolean enable) throws SQLException {
    throw new SQLException("setEscapeProcessing(boolean enable) not supported");
  }

  @Override
  public int getQueryTimeout() throws SQLException {
    throw new SQLException("getQueryTimeout() not supported");
  }

  @Override
  public void setQueryTimeout(int seconds) throws SQLException {
    throw new SQLException("setQueryTimeout(int seconds) not supported");
  }

  @Override
  public void cancel() throws SQLException {
  }

  @Override
  public SQLWarning getWarnings() throws SQLException {
    return stmt.getWarnings();
  }

  @Override
  public void clearWarnings() throws SQLException {

  }

  @Override
  public void setCursorName(String name) throws SQLException {

  }

  @Override
  public int getUpdateCount() throws SQLException {
    return 1;
  }

  @Override
  public boolean getMoreResults() throws SQLException {
    throw new SQLException("getMoreResults() not supported");
  }

  @Override
  public void setFetchDirection(int direction) throws SQLException {
    throw new SQLException("setFetchDirection(int direction) not supported");
  }

  @Override
  public int getFetchDirection() throws SQLException {
    throw new SQLException("getFetchDirection() not supported");
  }

  @Override
  public void setFetchSize(int rows) throws SQLException {
    throw new SQLException("setFetchSize(int rows) not supported");
  }

  @Override
  public int getFetchSize() throws SQLException {
    throw new SQLException("getFetchSize() not supported");
  }

  @Override
  public int getResultSetConcurrency() throws SQLException {
    throw new SQLException("getResultSetConcurrency() not supported");
  }

  @Override
  public int getResultSetType() throws SQLException {
    return getResultSetType();
  }

  @Override
  public void addBatch(String sql) throws SQLException {
    throw new SQLException("addBatch(String sql) not supported");
  }

  @Override
  public void clearBatch() throws SQLException {
    throw new SQLException("clearBatch()  not supported");
  }

  @Override
  public int[] executeBatch() throws SQLException {
    throw new SQLException("executeBatch()  not supported");
  }

  @Override
  public Connection getConnection() throws SQLException {
    return connection;
  }

  @Override
  public boolean getMoreResults(int current) throws SQLException {
    throw new SQLException("getMoreResults(int current) not supported");
  }

  @Override
  public ResultSet getGeneratedKeys() throws SQLException {
    throw new SQLException("getGeneratedKeys()not supported");
  }


  @Override
  public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
    throw new SQLException("executeUpdate(String sql, int autoGeneratedKeys) not supported");
  }

  @Override
  public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
    throw new SQLException("executeUpdate(String sql, int[] columnIndexes) not supported");
  }

  @Override
  public int executeUpdate(String sql, String[] columnNames) throws SQLException {
    throw new SQLException("executeUpdate(String sql, String[] columnNames) not supported");
  }

  @Override
  public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
    throw new SQLException("execute(String sql, int autoGeneratedKeys) not supported");
  }

  @Override
  public boolean execute(String sql, int[] columnIndexes) throws SQLException {
    throw new SQLException("execute(String sql, int[] columnIndexes) not supported");
  }

  @Override
  public boolean execute(String sql, String[] columnNames) throws SQLException {
    throw new SQLException("execute(String sql, String[] columnNames) not supported");
  }

  @Override
  public int getResultSetHoldability() throws SQLException {
    throw new SQLException("getResultSetHoldability() not supported");
  }

  @Override
  public boolean isClosed() throws SQLException {
    return isClosed;
  }

  @Override
  public void setPoolable(boolean poolable) throws SQLException {
    throw new SQLException("setPoolable(boolean poolable) not supported");
  }

  @Override
  public boolean isPoolable() throws SQLException {
    throw new SQLException("isPoolable() not supported");
  }

  @Override
  public void closeOnCompletion() throws SQLException {
  }

  @Override
  public boolean isCloseOnCompletion() throws SQLException {
    throw new SQLException("isCloseOnCompletion() not supported");
  }

  @Override
  public <T> T unwrap(Class<T> iface) throws SQLException {
    throw new SQLException("unwrap(Class<T> iface) not supported");
  }

  @Override
  public boolean isWrapperFor(Class<?> iface) throws SQLException {
    return false;
  }
}
