/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.lindorm.sql.se.search;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.convert.ConverterRule;

/**
 * Rule to convert a relational expression from {@link SearchRel#CONVENTION} to {@link EnumerableConvention}.
 */
class SearchToEnumerableConverterRule extends ConverterRule {
  static final ConverterRule INSTANCE = new SearchToEnumerableConverterRule();

  private SearchToEnumerableConverterRule() {
    super(RelNode.class, SearchRel.CONVENTION, EnumerableConvention.INSTANCE, "SolrToEnumerableConverterRule");
  }

  @Override
  public RelNode convert(RelNode rel) {
    RelTraitSet newTraitSet = rel.getTraitSet().replace(getOutConvention());
    return new SearchToEnumerableConverter(rel.getCluster(), newTraitSet, rel);
  }
}
