/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.datasource.routing;

import com.alilitech.datasource.routing.DefaultDynamicDataSource;
import com.alilitech.datasource.routing.encrypt.resolver.EncryptPropertyResolver;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DynamicDataSourceRegister
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware,
ApplicationContextAware {
    private static final String DATASOURCE_BEAN_NAME = "dataSource";
    private Environment environment;
    private ApplicationContext context;
    private static final String SPRING_DATASOURCE_PREFIX = "spring.datasource";
    private final ConfigurationPropertyName SPRING_DATASOURCE = ConfigurationPropertyName.of((CharSequence)"spring.datasource");
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);
    private EncryptPropertyResolver encryptPropertyResolver;
    private BindHandler bindHandler = new BindHandler(){

        public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
            if (DynamicDataSourceRegister.this.encryptPropertyResolver != null && target.getType().getType().equals(String.class) && DynamicDataSourceRegister.this.encryptPropertyResolver.supportResolve(name.toString(), result.toString())) {
                result = DynamicDataSourceRegister.this.encryptPropertyResolver.resolve(result.toString());
                return result;
            }
            return result;
        }
    };

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (!registry.containsBeanDefinition(DATASOURCE_BEAN_NAME)) {
            return;
        }
        BeanDefinition beanDefinition = registry.getBeanDefinition(DATASOURCE_BEAN_NAME);
        if (beanDefinition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition abstractBeanDefinition = (AbstractBeanDefinition)beanDefinition;
            registry.removeBeanDefinition(DATASOURCE_BEAN_NAME);
            registry.registerBeanDefinition("defaultDataSource", (BeanDefinition)abstractBeanDefinition);
            GenericBeanDefinition dynamicBeanDefinition = new GenericBeanDefinition();
            dynamicBeanDefinition.setBeanClass(DefaultDynamicDataSource.class);
            dynamicBeanDefinition.setSynthetic(true);
            dynamicBeanDefinition.setPrimary(true);
            HashMap<Object, Object> targetDataSources = new HashMap<Object, Object>();
            this.addConfigDataSource(targetDataSources);
            MutablePropertyValues mpv = dynamicBeanDefinition.getPropertyValues();
            mpv.addPropertyValue("targetDataSources", targetDataSources);
            registry.registerBeanDefinition(DATASOURCE_BEAN_NAME, (BeanDefinition)dynamicBeanDefinition);
        }
    }

    private void addConfigDataSource(Map<Object, Object> targetDataSources) {
        Binder binder = Binder.get((Environment)this.environment);
        Map datasourceMap = (Map)binder.bind(this.SPRING_DATASOURCE, STRING_STRING_MAP).orElseGet(Collections::emptyMap);
        ArrayList dataSourceNames = new ArrayList();
        datasourceMap.forEach((k, v) -> {
            String dataSourceName;
            if (k.startsWith("ds") && !dataSourceNames.contains(dataSourceName = k.split("\\.")[0])) {
                dataSourceNames.add(dataSourceName);
            }
        });
        if (dataSourceNames.size() > 0) {
            try {
                this.encryptPropertyResolver = (EncryptPropertyResolver)this.context.getBean(EncryptPropertyResolver.class);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        dataSourceNames.forEach(dataSourceName -> targetDataSources.put(dataSourceName, this.buildDataSource((String)dataSourceName)));
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    private DataSource buildDataSource(String dataSourceName) {
        BindResult bindResult = this.encryptPropertyResolver == null ? Binder.get((Environment)this.environment).bind("spring.datasource." + dataSourceName, DataSourceProperties.class) : Binder.get((Environment)this.environment).bind("spring.datasource." + dataSourceName, Bindable.of(DataSourceProperties.class), this.bindHandler);
        DataSource dataSource = ((DataSourceProperties)bindResult.get()).initializeDataSourceBuilder().build();
        if (this.hasClass("com.zaxxer.hikari.HikariDataSource") && dataSource instanceof HikariDataSource) {
            IgnoreTopLevelConverterNotFoundBindHandler bindHandler = new IgnoreTopLevelConverterNotFoundBindHandler();
            Bindable target = Bindable.of(HikariDataSource.class).withExistingValue((Object)((HikariDataSource)dataSource));
            Binder.get((Environment)this.environment).bind("spring.datasource." + dataSourceName + ".hikari", target, (BindHandler)bindHandler);
        }
        return dataSource;
    }

    private boolean hasClass(String className) {
        boolean hasClassHikariDataSource;
        ClassLoader classLoader = this.context.getClassLoader();
        try {
            DynamicDataSourceRegister.forName(className, classLoader);
            hasClassHikariDataSource = true;
        }
        catch (Throwable ex) {
            hasClassHikariDataSource = false;
        }
        return hasClassHikariDataSource;
    }

    private static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader != null) {
            return classLoader.loadClass(className);
        }
        return Class.forName(className);
    }
}

