/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.datasource.routing;

import com.alilitech.datasource.routing.DataSourceContextHolder;
import com.alilitech.datasource.routing.DynamicRoutingDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class DefaultDynamicDataSource
extends DynamicRoutingDataSource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    protected Object determineCurrentLookupKey() {
        String dataSourceKey = DataSourceContextHolder.getDataSource() == null ? "default" : DataSourceContextHolder.getDataSource();
        this.log.trace("Current DataSource is [{}]", (Object)dataSourceKey);
        return dataSourceKey;
    }

    public void saveDataSource(String lookupKey, String driverClassName, String url, String username, String password) {
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setDriverClassName(driverClassName);
        dataSourceProperties.setUsername(username);
        dataSourceProperties.setPassword(password);
        dataSourceProperties.setUrl(url);
        DataSource dataSource = dataSourceProperties.initializeDataSourceBuilder().build();
        this.resolvedDataSources.put(lookupKey, dataSource);
    }

    public void saveDataSource(String lookupKey, String url, String username, String password) {
        this.saveDataSource(lookupKey, null, url, username, password);
    }

    public void removeDataSource(String lookupKey) {
        this.resolvedDataSources.remove(lookupKey);
    }
}

