/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.datasource.routing.aop;

import com.alilitech.datasource.routing.DataSourceContextHolder;
import com.alilitech.datasource.routing.annotation.DynamicSource;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class DynamicDataSourceAspect
implements Ordered {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Before(value="@annotation(com.alilitech.datasource.routing.annotation.DynamicSource) || @within(com.alilitech.datasource.routing.annotation.DynamicSource)")
    public void beforeSwitchDataSource(JoinPoint point) throws NoSuchMethodException {
        Class<?> clazz = point.getTarget().getClass();
        String methodName = point.getSignature().getName();
        Class[] argClass = ((MethodSignature)point.getSignature()).getParameterTypes();
        Method method = clazz.getMethod(methodName, argClass);
        String dataSourceName = null;
        if (method.isAnnotationPresent(DynamicSource.class) || clazz.isAnnotationPresent(DynamicSource.class)) {
            DynamicSource annotation = method.getAnnotation(DynamicSource.class);
            if (annotation == null) {
                annotation = clazz.getAnnotation(DynamicSource.class);
            }
            dataSourceName = annotation.runtime() ? DataSourceContextHolder.getDataSource() : annotation.value();
        }
        DataSourceContextHolder.setDataSource(dataSourceName);
        if (dataSourceName != null && this.logger.isDebugEnabled()) {
            this.logger.debug("current transaction use datasource\uff1a{}", (Object)dataSourceName);
        }
    }

    @After(value="@annotation(com.alilitech.datasource.routing.annotation.DynamicSource) || @within(com.alilitech.datasource.routing.annotation.DynamicSource)")
    public void afterSwitchDataSource() {
        DataSourceContextHolder.clearDataSource();
    }

    public int getOrder() {
        return -1;
    }
}

