/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate;

import com.alilitech.generate.DynamicCompileException;
import com.alilitech.generate.JavaSrc;
import com.alilitech.generate.MemoryJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.logging.Log;

public class DynamicLoader {
    protected static final List<String> classpaths = new ArrayList<String>();
    public static Log log;

    private DynamicLoader() {
    }

    public static Map<String, byte[]> compile(String javaSrc) {
        Pattern pattern = Pattern.compile("public\\s+class\\s+(\\w+)");
        Matcher matcher = pattern.matcher(javaSrc);
        if (matcher.find()) {
            return DynamicLoader.compile(matcher.group(1) + ".java", javaSrc);
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, byte[]> compile(String javaName, String javaSrc) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager stdManager = compiler.getStandardFileManager(null, null, null);
        try (MemoryJavaFileManager manager = new MemoryJavaFileManager(stdManager);){
            List files = classpaths.stream().map(File::new).collect(Collectors.toList());
            stdManager.setLocation(StandardLocation.CLASS_PATH, files);
            JavaFileObject javaFileObject = MemoryJavaFileManager.makeStringSource(javaName, javaSrc);
            JavaCompiler.CompilationTask task = compiler.getTask(null, manager, null, null, null, Arrays.asList(javaFileObject));
            if (Boolean.TRUE.equals(task.call())) {
                Map<String, byte[]> map = manager.getClassBytes();
                return map;
            }
            log.warn((CharSequence)"\u52a8\u6001\u7f16\u8bd1\u5931\u8d25\uff01");
            return Collections.emptyMap();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DynamicCompileException(e);
        }
    }

    public static Map<String, byte[]> compile(List<JavaSrc> javaSrcs) {
        HashMap<String, byte[]> retMap = new HashMap<String, byte[]>();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticListeners = new DiagnosticCollector();
        StandardJavaFileManager stdManager = compiler.getStandardFileManager(diagnosticListeners, Locale.getDefault(), StandardCharsets.UTF_8);
        try (MemoryJavaFileManager manager = new MemoryJavaFileManager(stdManager);){
            List files = classpaths.stream().map(File::new).collect(Collectors.toList());
            stdManager.setLocation(StandardLocation.CLASS_PATH, files);
            ArrayList<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>();
            for (JavaSrc javaSrc : javaSrcs) {
                JavaFileObject javaFileObject = MemoryJavaFileManager.makeStringSource(javaSrc.getJavaName(), javaSrc.getJavaSrcStr());
                javaFileObjects.add(javaFileObject);
            }
            JavaCompiler.CompilationTask task = compiler.getTask(null, manager, diagnosticListeners, null, null, javaFileObjects);
            if (Boolean.TRUE.equals(task.call())) {
                retMap.putAll(manager.getClassBytes());
            } else {
                log.warn((CharSequence)"\u52a8\u6001\u7f16\u8bd1\u5931\u8d25");
                for (Diagnostic diagnostic : diagnosticListeners.getDiagnostics()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((CharSequence)diagnostic.getMessage(Locale.getDefault()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DynamicCompileException(e);
        }
        return retMap;
    }

    public static class MemoryClassLoader
    extends URLClassLoader {
        Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

        public MemoryClassLoader(Map<String, byte[]> classBytes) {
            super(new URL[0], MemoryClassLoader.class.getClassLoader());
            this.classBytes.putAll(classBytes);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] buf = this.classBytes.get(name);
            if (buf == null) {
                return super.findClass(name);
            }
            this.classBytes.remove(name);
            return this.defineClass(name, buf, 0, buf.length);
        }
    }
}

