/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate;

import com.alilitech.generate.DynamicLoader;
import com.alilitech.generate.GeneratorUtils;
import com.alilitech.generate.XmlParser;
import com.alilitech.generate.config.DataSourceConfig;
import com.alilitech.generate.config.GlobalConfig;
import com.alilitech.generate.config.TableConfig;
import com.alilitech.generate.definition.ClassDefinition;
import com.alilitech.generate.definition.ClassType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE)
public class GeneratorMojo
extends AbstractMojo {
    private String xmlPath = "generate.xml";

    public void execute() throws MojoExecutionException, MojoFailureException {
        URL[] urls = ((PluginDescriptor)this.getPluginContext().get("pluginDescriptor")).getClassRealm().getURLs();
        if (urls != null) {
            for (URL url : urls) {
                DynamicLoader.classpaths.add(url.getPath());
            }
        }
        DynamicLoader.log = this.getLog();
        MavenProject mavenProject = (MavenProject)this.getPluginContext().get("project");
        List compileSourceRoots = mavenProject.getCompileSourceRoots();
        if (compileSourceRoots == null || compileSourceRoots.isEmpty()) {
            throw new MojoExecutionException("Plugin was not found Java Source path.");
        }
        String srcPath = compileSourceRoots.get(0).toString();
        List resources = mavenProject.getResources();
        if (resources == null || resources.isEmpty()) {
            throw new MojoExecutionException("Plugin was not found Java Resource path.");
        }
        AtomicReference resourcePath = new AtomicReference();
        resources.forEach(resource -> {
            String directory = ((Resource)resource).getDirectory();
            if (new File(directory + File.separator + this.xmlPath).exists()) {
                resourcePath.set(directory);
                return;
            }
        });
        XmlParser xmlParser = new XmlParser((String)resourcePath.get() + File.separator + this.xmlPath);
        DataSourceConfig dataSourceConfig = xmlParser.parseText("config.datasource", DataSourceConfig.class);
        GlobalConfig globalConfig = xmlParser.parseText("config.properties", GlobalConfig.class);
        List<TableConfig> tableConfigs = xmlParser.parseListAttribute("config.tables.table", TableConfig.class);
        GeneratorUtils.log = this.getLog();
        List<ClassDefinition> classDefinitions = GeneratorUtils.process(dataSourceConfig, globalConfig, tableConfigs);
        for (int i = 0; i < classDefinitions.size(); ++i) {
            ClassDefinition classDefinition = classDefinitions.get(i);
            try {
                boolean mkdirs;
                String fileDirectory = srcPath + File.separator + classDefinition.getPackageName().replace(".", "/");
                File fileDir = new File(fileDirectory);
                if (!fileDir.exists() && !(mkdirs = fileDir.mkdirs())) {
                    throw new MojoFailureException("\u65e0\u6cd5\u6839\u636e\u5305\u8def\u5f84\u5efa\u7acb\u6587\u4ef6\u5939");
                }
                File fileJava = new File(fileDirectory + File.separator + classDefinition.getClassName() + ".java");
                int tableIndex = i / 2;
                TableConfig tableConfig = tableConfigs.get(tableIndex);
                if (!fileJava.exists()) {
                    classDefinition.out(new FileOutputStream(fileJava));
                    continue;
                }
                if (fileJava.exists() && classDefinition.getClassType() == ClassType.DOMAIN && tableConfig.isOverrideDomain()) {
                    classDefinition.out(new FileOutputStream(fileJava));
                }
                if (!fileJava.exists() || classDefinition.getClassType() != ClassType.MAPPER || !tableConfig.isOverrideMapper()) continue;
                classDefinition.out(new FileOutputStream(fileJava));
                continue;
            }
            catch (IOException e) {
                throw new MojoFailureException("\u751f\u6210\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

