/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate;

import com.alilitech.generate.DynamicLoader;
import com.alilitech.generate.JavaSrc;
import com.alilitech.generate.Table;
import com.alilitech.generate.TableColumn;
import com.alilitech.generate.config.DataSourceConfig;
import com.alilitech.generate.config.GlobalConfig;
import com.alilitech.generate.config.TableConfig;
import com.alilitech.generate.definition.AnnotationDefinition;
import com.alilitech.generate.definition.ClassDefinition;
import com.alilitech.generate.definition.ClassType;
import com.alilitech.generate.definition.FieldDefinition;
import com.alilitech.mybatis.jpa.anotation.GeneratedValue;
import com.alilitech.mybatis.jpa.mapper.PageMapper;
import com.alilitech.mybatis.jpa.parameter.GenerationType;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import org.apache.maven.plugin.logging.Log;

public class GeneratorUtils {
    public static Log log;

    private GeneratorUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ClassDefinition> process(DataSourceConfig dataSourceConfig, GlobalConfig globalConfig, List<TableConfig> tableConfigList) {
        ArrayList<Table> tables = new ArrayList<Table>();
        ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>();
        Connection connection = null;
        try {
            Class.forName(dataSourceConfig.getDriverName());
            connection = DriverManager.getConnection(dataSourceConfig.getUrl(), dataSourceConfig.getUsername(), dataSourceConfig.getPassword());
            DatabaseMetaData metaData = connection.getMetaData();
            String catalog = connection.getCatalog();
            for (TableConfig tableConfig : tableConfigList) {
                String tableName = tableConfig.getTableName();
                ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
                ResultSet rsPK = metaData.getPrimaryKeys(catalog, null, tableName);
                String pkColumn = null;
                if (rsPK.next()) {
                    pkColumn = rsPK.getString("COLUMN_NAME");
                }
                ResultSet rs = metaData.getColumns(catalog, "%", tableName, "%");
                while (rs.next()) {
                    TableColumn tableColumn = new TableColumn();
                    int columnType = rs.getInt("DATA_TYPE");
                    int columnSize = rs.getInt("COLUMN_SIZE");
                    String columnName = rs.getString("COLUMN_NAME");
                    boolean isNull = rs.getInt("NULLABLE") == 1;
                    int scale = rs.getInt("DECIMAL_DIGITS");
                    String remark = rs.getString("REMARKS");
                    String defaultValue = rs.getString("COLUMN_DEF");
                    String isAutoIncrement = rs.getString("IS_AUTOINCREMENT");
                    tableColumn.setColumnName(columnName);
                    tableColumn.setColumnSize(columnSize);
                    tableColumn.setColumnType(GeneratorUtils.covertDomain(columnType, columnSize));
                    tableColumn.setDefaultValue(defaultValue);
                    tableColumn.setNullAble(isNull);
                    tableColumn.setPrimary(columnName.equals(pkColumn));
                    tableColumn.setRemark(remark);
                    tableColumn.setAutoIncrement("YES".equals(isAutoIncrement));
                    tableColumn.setScale(scale);
                    tableColumns.add(tableColumn);
                }
                rsPK.close();
                rs.close();
                Table table2 = new Table(tableColumns, tableConfig);
                tables.add(table2);
            }
        }
        catch (ClassNotFoundException | SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        tables.forEach(table -> {
            ClassDefinition domainClassDefinition = GeneratorUtils.covertDomain(table, globalConfig.getPackageName());
            classDefinitions.add(domainClassDefinition);
            Class<?> domainClass = GeneratorUtils.loadClass(new HashMap<String, byte[]>(), classDefinitions);
            domainClassDefinition.addAnnotation("Getter").addAnnotation("Setter").addImport("lombok.Getter").addImport("lombok.Setter");
            ClassDefinition mapperDefinition = GeneratorUtils.covertMapper(table, globalConfig.getPackageName(), domainClass);
            classDefinitions.add(mapperDefinition);
        });
        return classDefinitions;
    }

    private static Class<?> covertDomain(int columnType, int columnSize) {
        switch (columnType) {
            case 91: {
                return LocalDate.class;
            }
            case 92: 
            case 93: {
                return LocalDateTime.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case -5: {
                return Long.class;
            }
            case 4: {
                return Integer.class;
            }
            case -6: {
                if (columnSize == 1) {
                    return Boolean.class;
                }
                return Integer.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2011: {
                return Byte[].class;
            }
        }
        return String.class;
    }

    private static ClassDefinition covertDomain(Table table, String globalPackageName) {
        ClassDefinition classDefinition = new ClassDefinition(table.getTableConfig().getDomainName());
        classDefinition.setClassType(ClassType.DOMAIN).setPackageName(globalPackageName + "." + ClassType.DOMAIN.getType());
        classDefinition.addAnnotation(new AnnotationDefinition(javax.persistence.Table.class).addProperty("name", table.getTableConfig().getTableName()));
        table.getTableColumns().forEach(tableColumn -> {
            FieldDefinition fieldDefinition = new FieldDefinition(tableColumn.getColumnType(), tableColumn.getProperty());
            if (tableColumn.isPrimary()) {
                fieldDefinition.addAnnotation(Id.class);
                fieldDefinition.addAnnotation(new AnnotationDefinition(GeneratedValue.class).addProperty("value", GenerationType.AUTO));
            }
            if (tableColumn.getRemark() != null && !tableColumn.getRemark().equals("")) {
                fieldDefinition.addComment(tableColumn.getRemark());
            }
            if (!tableColumn.isStandardUnderscore() && !table.getTableConfig().isIgnoreNoStandardUnderscore()) {
                fieldDefinition.addAnnotation(new AnnotationDefinition(Column.class).addProperty("name", tableColumn.getColumnName()));
            }
            classDefinition.addFieldDefinition(fieldDefinition);
        });
        return classDefinition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> loadClass(Map<String, byte[]> exist, List<ClassDefinition> classDefinitions) {
        ArrayList<JavaSrc> javaSrcList = new ArrayList<JavaSrc>();
        String retJavaName = null;
        for (int i = 0; i < classDefinitions.size(); ++i) {
            ClassDefinition classDefinition = classDefinitions.get(i);
            String javaSrc = classDefinition.toString();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)(classDefinition.getClassName() + "==>" + javaSrc));
            }
            String javaName = classDefinition.getClassName();
            if (classDefinition.getPackageName() != null && !classDefinition.getPackageName().equals("")) {
                javaName = classDefinition.getPackageName() + "." + javaName;
            }
            javaSrcList.add(new JavaSrc(javaName + ".java", javaSrc));
            if (i != classDefinitions.size() - 1) continue;
            retJavaName = javaName;
        }
        Map<String, byte[]> compile = DynamicLoader.compile(javaSrcList);
        if (exist != null) {
            compile.putAll(exist);
        }
        try (DynamicLoader.MemoryClassLoader memoryClassLoader = new DynamicLoader.MemoryClassLoader(compile);){
            Class<?> clazz = memoryClassLoader.findClass(retJavaName);
            return clazz;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ClassDefinition covertMapper(Table table, String globalPackageName, Class<?> domainClass) {
        Field[] fields;
        ClassDefinition classDefinition = new ClassDefinition(table.getTableConfig().getDomainName() + "Mapper");
        classDefinition.setClassType(ClassType.MAPPER).setPackageName(globalPackageName + "." + ClassType.MAPPER.getType());
        classDefinition.setInterfaced(true);
        Class<?> idClass = null;
        for (Field field : fields = domainClass.getDeclaredFields()) {
            if (field.getAnnotation(Id.class) == null) continue;
            idClass = field.getType();
            break;
        }
        TypeResolver typeResolver = new TypeResolver();
        ResolvedType resolvedType = typeResolver.resolve(PageMapper.class, new Type[]{domainClass, idClass});
        classDefinition.addExtend(resolvedType);
        return classDefinition;
    }
}

