/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlParser {
    private Document document;

    public XmlParser(String xmlPath) {
        SAXReader saxReader = new SAXReader();
        try {
            this.document = saxReader.read(xmlPath);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    public XmlParser(InputStream inputStream) {
        SAXReader saxReader = new SAXReader();
        try {
            this.document = saxReader.read(inputStream);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T parseText(String elementPath, Class<T> clazz) {
        T t;
        String[] nodeArray = elementPath.split("\\.");
        Element element = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            element = i == 0 ? this.document.getRootElement() : element.element(nodeArray[i]);
        }
        try {
            t = clazz.newInstance();
            for (Field field : clazz.getDeclaredFields()) {
                String text = element.elementText(field.getName());
                if (text == null) continue;
                field.setAccessible(true);
                field.set(t, this.covertFieldValue(text, field));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    public <T> T parseAttribute(String elementPath, Class<T> clazz) {
        T t;
        String[] nodeArray = elementPath.split("\\.");
        Element element = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            element = i == 0 ? this.document.getRootElement() : element.element(nodeArray[i]);
        }
        try {
            t = clazz.newInstance();
            for (Field field : clazz.getDeclaredFields()) {
                String text = element.attributeValue(field.getName());
                if (text == null) continue;
                field.setAccessible(true);
                field.set(t, this.covertFieldValue(text, field));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    public <T> List<T> parseListAttribute(String elementPath, Class<T> clazz) {
        ArrayList<T> retList = new ArrayList<T>();
        String[] nodeArray = elementPath.split("\\.");
        Element element = null;
        List elements = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (i == 0) {
                element = this.document.getRootElement();
                continue;
            }
            if (i >= nodeArray.length - 1) {
                elements = element.elements(nodeArray[i]);
                continue;
            }
            element = element.element(nodeArray[i]);
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        for (Element temp : elements) {
            try {
                T t = clazz.newInstance();
                for (Field field : declaredFields) {
                    String text = temp.attributeValue(field.getName());
                    if (text == null) continue;
                    field.setAccessible(true);
                    field.set(t, this.covertFieldValue(text, field));
                }
                retList.add(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return retList;
    }

    private Object covertFieldValue(String value, Field field) {
        if (field.getType().equals(String.class)) {
            return value;
        }
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }
}

