/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate.config;

import com.alilitech.generate.utils.StyleConvertUtils;

public class TableConfig {
    private String tableName;
    private String domainName;
    private boolean overrideDomain = true;
    private boolean overrideMapper = false;
    private boolean ignoreNoStandardUnderscore = false;

    public TableConfig() {
    }

    public TableConfig(String tableName) {
        this(tableName, StyleConvertUtils.getUpperCamelCaseStyle(tableName));
    }

    public TableConfig(String tableName, String domainName) {
        this.tableName = tableName;
        this.domainName = domainName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDomainName() {
        if (this.domainName == null || this.domainName.equals("")) {
            return StyleConvertUtils.getUpperCamelCaseStyle(this.tableName);
        }
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public boolean isOverrideDomain() {
        return this.overrideDomain;
    }

    public void setOverrideDomain(boolean overrideDomain) {
        this.overrideDomain = overrideDomain;
    }

    public boolean isOverrideMapper() {
        return this.overrideMapper;
    }

    public void setOverrideMapper(boolean overrideMapper) {
        this.overrideMapper = overrideMapper;
    }

    public boolean isIgnoreNoStandardUnderscore() {
        return this.ignoreNoStandardUnderscore;
    }

    public void setIgnoreNoStandardUnderscore(boolean ignoreNoStandardUnderscore) {
        this.ignoreNoStandardUnderscore = ignoreNoStandardUnderscore;
    }
}

