/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate.definition;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class AnnotationDefinition {
    private Set<String> importList;
    private Class<?> clazz;
    private Map<String, String> properties;

    public AnnotationDefinition() {
    }

    public AnnotationDefinition(Class<?> clazz) {
        this.clazz = clazz;
        this.addImport(clazz.getName());
    }

    public AnnotationDefinition setClazz(Class<?> clazz) {
        this.clazz = clazz;
        this.addImport(clazz.getName());
        return this;
    }

    public AnnotationDefinition addProperty(String propertyName, Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        if (propertyName == null || propertyName.trim().equals("")) {
            propertyName = "value";
        }
        if (value instanceof String) {
            this.properties.put(propertyName, "\"" + value.toString() + "\"");
        } else if (value instanceof Class) {
            Class temp = (Class)value;
            this.properties.put(propertyName, temp.getSimpleName() + ".class");
            this.addImport(temp.getName());
        } else if (value.getClass().isEnum()) {
            Enum anEnum = (Enum)value;
            this.properties.put(propertyName, value.getClass().getSimpleName() + "." + anEnum.name());
            this.addImport(value.getClass().getName());
        } else if (value.getClass().isArray() || value.getClass().isAnnotation()) {
            // empty if block
        }
        return this;
    }

    private AnnotationDefinition addImport(String importString) {
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importString);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getImportList() {
        return this.importList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.clazz.getSimpleName() + "(");
        ArrayList propertyStr = new ArrayList();
        this.properties.forEach((key, value) -> propertyStr.add(key + " = " + value));
        String join = String.join((CharSequence)",", propertyStr);
        builder.append(join);
        builder.append(")");
        return builder.toString();
    }
}

