/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate.definition;

import com.alilitech.generate.definition.AnnotationDefinition;
import com.alilitech.generate.definition.ClassType;
import com.alilitech.generate.definition.FieldDefinition;
import com.alilitech.generate.definition.MethodDefinition;
import com.alilitech.generate.definition.ParameterDefinition;
import com.fasterxml.classmate.ResolvedType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ClassDefinition {
    private ClassType classType;
    private String packageName;
    private Set<String> importList;
    private List<String> comments;
    private String scope = "public";
    private String className;
    private List<String> extendClassList;
    private boolean interfaced;
    private boolean abstracted;
    private List<String> implementClassList;
    private List<String> annotationList;
    private List<FieldDefinition> fieldDefinitions;
    private List<MethodDefinition> methodDefinitions;

    public ClassType getClassType() {
        return this.classType;
    }

    public ClassDefinition setClassType(ClassType classType) {
        this.classType = classType;
        return this;
    }

    public ClassDefinition(String className) {
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassDefinition setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public ClassDefinition setInterfaced(boolean interfaced) {
        this.interfaced = interfaced;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public ClassDefinition setAbstracted(boolean abstracted) {
        this.abstracted = abstracted;
        return this;
    }

    public ClassDefinition addImport(String importString) {
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importString);
        return this;
    }

    public ClassDefinition addImport(Class<?> importClass) {
        if (importClass.getTypeName().startsWith("java.lang")) {
            return this;
        }
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importClass.getName());
        return this;
    }

    public ClassDefinition addComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(comment);
        return this;
    }

    public ClassDefinition addExtend(String extendClassName) {
        if (this.extendClassList == null) {
            this.extendClassList = new ArrayList<String>();
        }
        this.extendClassList.add(extendClassName);
        return this;
    }

    public ClassDefinition addExtend(ResolvedType resolvedType) {
        String extendStr = resolvedType.getErasedType().getSimpleName();
        List typeParameters = resolvedType.getTypeBindings().getTypeParameters();
        if (typeParameters != null && !typeParameters.isEmpty()) {
            List list = typeParameters.stream().map(resolvedType1 -> {
                this.addImport(resolvedType1.getErasedType());
                return resolvedType1.getErasedType().getSimpleName();
            }).collect(Collectors.toList());
            String join = String.join((CharSequence)", ", list);
            extendStr = extendStr + "<" + join + ">";
        }
        return this.addExtend(extendStr).addImport(resolvedType.getErasedType());
    }

    public ClassDefinition addExtend(Class<?> clazz) {
        return this.addExtend(clazz.getSimpleName()).addImport(clazz);
    }

    public ClassDefinition addImplement(String implementClassName) {
        if (this.implementClassList == null) {
            this.implementClassList = new ArrayList<String>();
        }
        this.implementClassList.add(implementClassName);
        return this;
    }

    public ClassDefinition addImplement(Class<?> clazz) {
        return this.addImplement(clazz.getSimpleName()).addImport(clazz);
    }

    public ClassDefinition addAnnotation(String annotationName) {
        if (this.annotationList == null) {
            this.annotationList = new ArrayList<String>();
        }
        this.annotationList.add(annotationName);
        return this;
    }

    public ClassDefinition addAnnotation(Class<?> clazz) {
        return this.addAnnotation(clazz.getSimpleName()).addImport(clazz);
    }

    public ClassDefinition addAnnotation(AnnotationDefinition annotationDefinition) {
        this.addAnnotation(annotationDefinition.toString());
        annotationDefinition.getImportList().forEach(this::addImport);
        return this;
    }

    public ClassDefinition addFieldDefinition(FieldDefinition fieldDefinition) {
        if (this.fieldDefinitions == null) {
            this.fieldDefinitions = new ArrayList<FieldDefinition>();
        }
        this.fieldDefinitions.add(fieldDefinition);
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        if (fieldDefinition.getImportList() != null) {
            this.importList.addAll(fieldDefinition.getImportList());
        }
        return this;
    }

    public ClassDefinition addMethodDefinition(MethodDefinition methodDefinition) {
        if (this.methodDefinitions == null) {
            this.methodDefinitions = new ArrayList<MethodDefinition>();
        }
        this.methodDefinitions.add(methodDefinition);
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        if (methodDefinition.getImportList() != null) {
            this.importList.addAll(methodDefinition.getImportList());
        }
        return this;
    }

    public List<MethodDefinition> getMethodDefinitions() {
        return this.methodDefinitions;
    }

    public void out(OutputStream outputStream) throws IOException {
        byte[] bytes = this.toString().getBytes();
        outputStream.write(bytes);
    }

    public String toString() {
        String lineEnd = "\r\n";
        StringBuilder builder = new StringBuilder();
        if (this.packageName != null) {
            builder.append("package " + this.packageName + ";" + lineEnd);
        }
        builder.append(lineEnd);
        if (this.importList != null) {
            this.importList.forEach(s -> builder.append("import " + s + ";" + lineEnd));
        }
        builder.append(lineEnd);
        if (this.comments != null) {
            builder.append("/**" + lineEnd);
            this.comments.forEach(s -> builder.append(" * " + s + lineEnd));
            builder.append(" */" + lineEnd);
        }
        if (this.annotationList != null) {
            this.annotationList.forEach(s -> builder.append("@" + s + lineEnd));
        }
        String classType = "class";
        if (this.interfaced) {
            classType = "interface";
        }
        builder.append(this.scope + (this.abstracted ? " abstract " : " ") + classType + " " + this.className);
        if (this.extendClassList != null) {
            builder.append(" extends ");
            builder.append(String.join((CharSequence)", ", this.extendClassList));
        }
        if (this.implementClassList != null) {
            builder.append(" implements ");
            builder.append(String.join((CharSequence)", ", this.implementClassList));
        }
        builder.append(" {" + lineEnd);
        builder.append(lineEnd);
        String space4 = "\t";
        if (this.fieldDefinitions != null) {
            for (FieldDefinition fieldDefinition : this.fieldDefinitions) {
                if (fieldDefinition.getComments() != null) {
                    builder.append(space4).append("/**").append(lineEnd);
                    fieldDefinition.getComments().forEach(s -> builder.append(space4 + " * " + s + lineEnd));
                    builder.append(space4 + " */" + lineEnd);
                }
                if (fieldDefinition.getAnnotationList() != null) {
                    fieldDefinition.getAnnotationList().forEach(s -> builder.append(space4).append("@").append((String)s).append(lineEnd));
                }
                builder.append(space4 + fieldDefinition.getScope() + " " + fieldDefinition.getType() + " " + fieldDefinition.getName() + ";" + lineEnd);
                builder.append(lineEnd);
            }
        }
        if (this.methodDefinitions != null) {
            for (MethodDefinition methodDefinition : this.methodDefinitions) {
                if (methodDefinition.getAnnotationList() != null) {
                    methodDefinition.getAnnotationList().forEach(s -> builder.append(space4).append("@").append((String)s).append(lineEnd));
                }
                builder.append(space4).append(methodDefinition.getScope()).append(" ").append(methodDefinition.getReturnValue()).append(" ").append(methodDefinition.getMethodName()).append("(");
                if (methodDefinition.getParameters() != null) {
                    for (int i = 0; i < methodDefinition.getParameters().size(); ++i) {
                        ParameterDefinition parameterDefinition = methodDefinition.getParameters().get(i);
                        if (i > 0) {
                            builder.append(", ");
                        }
                        if (parameterDefinition.getAnnotationList() != null) {
                            parameterDefinition.getAnnotationList().forEach(s -> builder.append("@").append((String)s).append(" "));
                        }
                        builder.append(parameterDefinition.getType()).append(" ").append(parameterDefinition.getName());
                    }
                }
                if (methodDefinition.isHasBody()) {
                    builder.append(") {").append(lineEnd);
                    if (methodDefinition.getBodyLines() != null) {
                        methodDefinition.getBodyLines().forEach(s -> builder.append(space4).append(space4).append((String)s).append(lineEnd));
                    }
                    builder.append(space4).append("}").append(lineEnd);
                } else {
                    builder.append(");").append(lineEnd);
                }
                builder.append(lineEnd);
            }
        }
        builder.append("}").append(lineEnd);
        return builder.toString();
    }
}

