/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate.definition;

import com.alilitech.generate.definition.AnnotationDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class FieldDefinition {
    private String scope = "private";
    private String type;
    private String name;
    private String initializationString;
    private List<String> annotationList;
    private List<String> comments;
    private Set<String> importList;

    public FieldDefinition(String name) {
        this.name = name;
    }

    public FieldDefinition(Class<?> type, String name) {
        this(type.getSimpleName(), name);
        this.addImport(type);
    }

    public FieldDefinition(String type, String name) {
        this(type, name, null);
    }

    public FieldDefinition(String type, String name, String initializationString) {
        this.name = name;
        this.type = type;
        this.initializationString = initializationString;
    }

    public String getScope() {
        return this.scope;
    }

    public FieldDefinition setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public FieldDefinition setTypeClass(Class<?> typeClass) {
        this.type = typeClass.getSimpleName();
        this.addImport(typeClass);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public FieldDefinition setName(String name) {
        this.name = name;
        return this;
    }

    public String getInitializationString() {
        return this.initializationString;
    }

    public FieldDefinition setInitializationString(String initializationString) {
        this.initializationString = initializationString;
        return this;
    }

    public List<String> getAnnotationList() {
        return this.annotationList;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public Set<String> getImportList() {
        return this.importList;
    }

    public FieldDefinition addImport(String importString) {
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importString);
        return this;
    }

    public FieldDefinition addImport(Class<?> importClass) {
        if (importClass.getTypeName().startsWith("java.lang")) {
            return this;
        }
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importClass.getName());
        return this;
    }

    public FieldDefinition addAnnotation(String annotationName) {
        if (this.annotationList == null) {
            this.annotationList = new ArrayList<String>();
        }
        this.annotationList.add(annotationName);
        return this;
    }

    public FieldDefinition addAnnotation(AnnotationDefinition annotationDefinition) {
        this.addAnnotation(annotationDefinition.toString());
        annotationDefinition.getImportList().forEach(this::addImport);
        return this;
    }

    public FieldDefinition addAnnotation(Class<?> clazz) {
        return this.addAnnotation(clazz.getSimpleName()).addImport(clazz);
    }

    public FieldDefinition addComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        this.comments.add(comment);
        return this;
    }
}

