/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate.definition;

import com.alilitech.generate.definition.ParameterDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MethodDefinition {
    private String scope = "public";
    private boolean hasBody = true;
    private String returnValue = "void";
    private String methodName;
    private List<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();
    private List<String> bodyLines = new ArrayList<String>();
    private List<String> annotationList;
    private Set<String> importList;

    public MethodDefinition(String methodName) {
        this.methodName = methodName;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isHasBody() {
        return this.hasBody;
    }

    public MethodDefinition setHasBody(boolean hasBody) {
        this.hasBody = hasBody;
        return this;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(String returnValue) {
        this.returnValue = returnValue;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public MethodDefinition setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public MethodDefinition setReturnValueClass(Class<?> returnValueClass) {
        this.setReturnValue(returnValueClass.getSimpleName());
        this.addImport(returnValueClass);
        return this;
    }

    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public MethodDefinition addImport(String importString) {
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importString);
        return this;
    }

    public MethodDefinition addImport(Class<?> importClass) {
        if (importClass.getTypeName().startsWith("java.lang")) {
            return this;
        }
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importClass.getName());
        return this;
    }

    public MethodDefinition addAnnotation(String annotationName) {
        if (this.annotationList == null) {
            this.annotationList = new ArrayList<String>();
        }
        this.annotationList.add(annotationName);
        return this;
    }

    public MethodDefinition addAnnotation(Class<?> clazz) {
        return this.addAnnotation(clazz.getSimpleName()).addImport(clazz);
    }

    public MethodDefinition addParameter(ParameterDefinition parameterDefinition) {
        this.parameters.add(parameterDefinition);
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        if (parameterDefinition.getImportList() != null) {
            this.importList.addAll(parameterDefinition.getImportList());
        }
        return this;
    }

    public MethodDefinition addBodyLines(String line, Class ... importClass) {
        this.bodyLines.add(line);
        if (importClass != null && importClass.length > 0) {
            for (Class aClass : importClass) {
                this.addImport(aClass);
            }
        }
        return this;
    }

    public Set<String> getImportList() {
        return this.importList;
    }

    public List<String> getBodyLines() {
        return this.bodyLines;
    }

    public List<String> getAnnotationList() {
        return this.annotationList;
    }
}

