/*
 * Decompiled with CFR 0.152.
 */
package com.alilitech.generate.definition;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ParameterDefinition {
    private String type;
    private String name;
    private Set<String> importList;
    private List<String> annotationList;

    public ParameterDefinition(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public ParameterDefinition setType(String type) {
        this.type = type;
        return this;
    }

    public ParameterDefinition setTypeClass(Class<?> typeClass) {
        this.type = typeClass.getSimpleName();
        this.addImport(typeClass);
        return this;
    }

    public ParameterDefinition addImport(String importString) {
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importString);
        return this;
    }

    public ParameterDefinition addImport(Class<?> importClass) {
        if (importClass.getTypeName().startsWith("java.lang")) {
            return this;
        }
        if (this.importList == null) {
            this.importList = new TreeSet<String>();
        }
        this.importList.add(importClass.getName());
        return this;
    }

    public ParameterDefinition addAnnotation(String annotationName) {
        if (this.annotationList == null) {
            this.annotationList = new ArrayList<String>();
        }
        this.annotationList.add(annotationName);
        return this;
    }

    public ParameterDefinition addAnnotation(Class<?> clazz) {
        return this.addAnnotation(clazz.getSimpleName()).addImport(clazz);
    }

    public String getName() {
        return this.name;
    }

    public ParameterDefinition setName(String name) {
        this.name = name;
        return this;
    }

    public Set<String> getImportList() {
        return this.importList;
    }

    public List<String> getAnnotationList() {
        return this.annotationList;
    }
}

