/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session;

import com.amadeus.session.JdkSerializerDeserializer;
import com.amadeus.session.SerializerDeserializer;
import com.amadeus.session.SessionManager;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptingSerializerDeserializer
implements SerializerDeserializer {
    private final SerializerDeserializer wrapped;
    private SecretKeySpec secretKey;
    private SecureRandom random;

    public EncryptingSerializerDeserializer() {
        this(new JdkSerializerDeserializer());
    }

    public EncryptingSerializerDeserializer(SerializerDeserializer wrapped) {
        this.wrapped = wrapped;
        this.random = new SecureRandom();
    }

    void initKey(String key) {
        try {
            byte[] keyArray = key.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            keyArray = sha.digest(keyArray);
            keyArray = Arrays.copyOf(keyArray, 16);
            this.secretKey = new SecretKeySpec(keyArray, "AES");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public byte[] serialize(Object value) {
        byte[] arrayToEncrypt = this.wrapped.serialize(value);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = new byte[16];
            this.random.nextBytes(iv);
            cipher.init(1, (Key)this.secretKey, new IvParameterSpec(iv));
            ByteBuffer output = ByteBuffer.allocate(iv.length + cipher.getOutputSize(arrayToEncrypt.length));
            output.put(iv);
            cipher.doFinal(ByteBuffer.wrap(arrayToEncrypt), output);
            return output.array();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object deserialize(byte[] data) {
        byte[] decrypted;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = new byte[16];
            System.arraycopy(data, 0, iv, 0, iv.length);
            cipher.init(2, (Key)this.secretKey, new IvParameterSpec(iv));
            decrypted = cipher.doFinal(data, iv.length, data.length - iv.length);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this.wrapped.deserialize(decrypted);
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.wrapped.setSessionManager(sessionManager);
        this.initKey(sessionManager.getConfiguration().getEncryptionKey());
    }
}

