/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session;

import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.SessionIdProvider;
import java.security.SecureRandom;

public class RandomIdProvider
implements SessionIdProvider {
    private static final int FILLER_CHARACTER_INDEX = 63;
    private static final int MASK_6_BITS = 63;
    private static final int DIVIDE_BY_64 = 6;
    private static final int MULTIPLY_BY_256 = 8;
    private static final int BYTES_IN_BLOCK = 3;
    private static final int DEFAULT_ID_LENGTH = 30;
    private static final int CHARACTERS_IN_BLOCK = 4;
    private static final char[] SESSION_ID_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private final SecureRandom random = new SecureRandom();
    private int length;

    public RandomIdProvider() {
        this(30);
    }

    RandomIdProvider(int length) {
        this.length = length;
    }

    private char[] encode(byte[] data) {
        char[] out = new char[RandomIdProvider.getLengthInCharacters(data.length)];
        char[] alphabet = SESSION_ID_ALPHABET;
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = RandomIdProvider.byteValue(data[i]);
            val <<= 8;
            if (++i < data.length) {
                val |= RandomIdProvider.byteValue(data[i]);
                trip = true;
            }
            val <<= 8;
            if (++i < data.length) {
                val |= RandomIdProvider.byteValue(data[i]);
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 63];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 63];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index] = alphabet[(val >>= 6) & 0x3F];
            ++i;
            index += 4;
        }
        return out;
    }

    private static int byteValue(byte data) {
        return 0xFF & data;
    }

    @Override
    public String newId() {
        byte[] bytes = new byte[this.length];
        this.random.nextBytes(bytes);
        return new String(this.encode(bytes));
    }

    @Override
    public String readId(String value) {
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        if (trimmedValue.isEmpty()) {
            return null;
        }
        if (trimmedValue.length() != this.getLengthInCharacters()) {
            return null;
        }
        return trimmedValue;
    }

    @Override
    public void configure(SessionConfiguration configuration) {
        String sessionIdLength = configuration.getAttribute("com.amadeus.session.id.length", "30");
        this.length = Integer.parseInt(sessionIdLength);
    }

    int getLengthInCharacters() {
        return RandomIdProvider.getLengthInCharacters(this.length);
    }

    static int getLengthInCharacters(int len) {
        return (len + 2) / 3 * 4;
    }
}

