/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.repository.redis.RedisFacade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisException;

abstract class AbstractJedisFacade
implements RedisFacade {
    private static final String CRLF = "\r\n";
    private static final String REDIS_VERSION_LABEL = "redis_version:";
    private static final Integer[] MIN_MULTISPOP_VERSION = new Integer[]{3, 2};
    private List<Integer> version;

    AbstractJedisFacade() {
    }

    @Override
    public boolean supportsMultiSpop() {
        this.readVersion();
        for (int i = 0; i < MIN_MULTISPOP_VERSION.length && i < this.version.size(); ++i) {
            if (this.version.get(i) >= MIN_MULTISPOP_VERSION[i]) continue;
            return false;
        }
        return true;
    }

    void readVersion() {
        if (this.version == null) {
            int start;
            String info = this.info("server");
            if (info != null && (start = info.indexOf(REDIS_VERSION_LABEL)) >= 0) {
                int end = info.indexOf(CRLF, start += REDIS_VERSION_LABEL.length());
                if (end < 0) {
                    end = info.length();
                }
                String[] coordiantes = info.substring(start, end).split("\\.");
                this.version = new ArrayList<Integer>();
                for (String coordinate : coordiantes) {
                    this.version.add(Integer.parseInt(coordinate));
                }
            }
            if (this.version == null) {
                this.version = Collections.singletonList(0);
            }
        }
    }

    @Override
    public boolean isRedisException(Exception e) {
        return e instanceof JedisException;
    }

    static RedisFacade.TransactionFacade wrapJedisTransaction(final Transaction t) {
        return new RedisFacade.TransactionFacade(){

            @Override
            public void hdel(byte[] key, byte[] ... fields) {
                t.hdel(key, fields);
            }

            @Override
            public void hmset(byte[] key, Map<byte[], byte[]> hash) {
                t.hmset(key, hash);
            }

            @Override
            public void del(byte[] ... keys) {
                t.del(keys);
            }

            @Override
            public RedisFacade.ResponseFacade<Set<byte[]>> smembers(final byte[] key) {
                return new RedisFacade.ResponseFacade<Set<byte[]>>(){

                    @Override
                    public Set<byte[]> get() {
                        return (Set)t.smembers(key).get();
                    }
                };
            }
        };
    }
}

