/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.SessionData;
import com.amadeus.session.SessionManager;
import com.amadeus.session.repository.redis.RedisExpirationStrategy;
import com.amadeus.session.repository.redis.RedisFacade;
import com.amadeus.session.repository.redis.RedisSessionRepository;
import com.amadeus.session.repository.redis.SafeEncoder;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SortedSetSessionExpirationManagement
implements RedisExpirationStrategy {
    private static Logger logger = LoggerFactory.getLogger((String)SortedSetSessionExpirationManagement.class.getName());
    static final String ALLSESSIONS_KEY = "com.amadeus.session:all-sessions-set:";
    static final int SESSION_PERSISTENCE_SAFETY_MARGIN = (int)TimeUnit.MINUTES.toSeconds(5L);
    private static final Long ONE = 1L;
    private static final int REGULAR_CLEANUP_INTERVAL = 10;
    private final RedisFacade redis;
    private final RedisSessionRepository repository;
    private final byte[] sessionToExpireKey;
    private ScheduledFuture<?> cleanupFuture;

    SortedSetSessionExpirationManagement(RedisFacade redis, RedisSessionRepository redisSession, String namespace) {
        this.redis = redis;
        this.repository = redisSession;
        this.sessionToExpireKey = SafeEncoder.encode(ALLSESSIONS_KEY + namespace);
    }

    @Override
    public void sessionDeleted(SessionData session) {
        this.redis.zrem(this.sessionToExpireKey, new byte[][]{this.repository.sessionKey(session.getId())});
    }

    @Override
    public void sessionTouched(SessionData session) {
        byte[] sessionKey = this.repository.sessionKey(session.getId());
        int sessionExpireInSeconds = session.getMaxInactiveInterval();
        if (sessionExpireInSeconds <= 0) {
            this.redis.persist(sessionKey);
            this.redis.zadd(this.sessionToExpireKey, Double.MAX_VALUE, sessionKey);
        } else {
            this.redis.zadd(this.sessionToExpireKey, session.expiresAt(), sessionKey);
            this.redis.expire(sessionKey, sessionExpireInSeconds + SESSION_PERSISTENCE_SAFETY_MARGIN);
        }
    }

    @Override
    public void startExpiredSessionsTask(SessionManager sessionManager) {
        CleanupTask task = new CleanupTask(sessionManager);
        long interval = Math.min(sessionManager.getConfiguration().getMaxInactiveInterval() / 10 + 1, 10);
        if (interval <= 0L) {
            interval = 10L;
        }
        logger.debug("Cleanup interval for sessions is {}", (Object)interval);
        this.cleanupFuture = sessionManager.schedule("redis.expiration-cleanup", task, interval);
    }

    @Override
    public void close() {
        if (this.cleanupFuture != null) {
            this.cleanupFuture.cancel(true);
            this.cleanupFuture = null;
        }
    }

    @Override
    public void sessionIdChange(SessionData sessionData) {
        this.redis.zrem(this.sessionToExpireKey, new byte[][]{this.repository.sessionKey(sessionData.getOldSessionId())});
        this.redis.zadd(this.sessionToExpireKey, sessionData.expiresAt(), this.repository.sessionKey(sessionData.getId()));
    }

    final class CleanupTask
    implements Runnable {
        private final SessionManager sessionManager;

        CleanupTask(SessionManager sessionManager) {
            this.sessionManager = sessionManager;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            logger.info("Cleaning up sessions expiring at {}", (Object)now);
            Set<byte[]> sessionsToExpire = SortedSetSessionExpirationManagement.this.redis.zrangeByScore(SortedSetSessionExpirationManagement.this.sessionToExpireKey, 0.0, now);
            if (sessionsToExpire != null && !sessionsToExpire.isEmpty()) {
                for (byte[] session : sessionsToExpire) {
                    if (!ONE.equals(SortedSetSessionExpirationManagement.this.redis.zrem(SortedSetSessionExpirationManagement.this.sessionToExpireKey, new byte[][]{session}))) continue;
                    String sessionId = RedisSessionRepository.extractSessionId(SafeEncoder.encode(session));
                    logger.debug("Starting cleanup of session '{}'", (Object)sessionId);
                    this.sessionManager.delete(sessionId, true);
                }
            }
        }
    }
}

