/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.repository.redis.AbstractJedisFacade;
import com.amadeus.session.repository.redis.RedisFacade;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterCommand;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;

class TransactionalJedisCluster
extends JedisCluster {
    TransactionalJedisCluster(Set<HostAndPort> hostAndPort, int timeout, JedisPoolConfig config) {
        super(hostAndPort, timeout, (GenericObjectPoolConfig)config);
    }

    public <T> RedisFacade.ResponseFacade<T> transaction(byte[] key, final RedisFacade.TransactionRunner<T> transaction) {
        return (RedisFacade.ResponseFacade)new JedisClusterCommand<RedisFacade.ResponseFacade<T>>(this.connectionHandler, this.maxAttempts){

            public RedisFacade.ResponseFacade<T> execute(Jedis connection) {
                Transaction t = connection.multi();
                RedisFacade.ResponseFacade response = transaction.run(AbstractJedisFacade.wrapJedisTransaction(t));
                t.exec();
                return response;
            }
        }.runBinary(key);
    }

    public String info(final String section) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            public String execute(Jedis connection) {
                return connection.info(section);
            }
        }.runWithAnyNode();
    }
}

