/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.RandomIdProvider;
import com.amadeus.session.RequestWithSession;
import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.SessionIdProvider;
import com.amadeus.session.SessionTracking;
import com.amadeus.session.UuidProvider;

public abstract class BaseSessionTracking
implements SessionTracking {
    protected String idName;
    protected SessionIdProvider idProvider;

    @Override
    public void configure(SessionConfiguration configuration) {
        String idProviderType;
        this.idName = configuration.getSessionIdName();
        switch (idProviderType = configuration.getAttribute("com.amadeus.session.id", "random")) {
            case "uuid": {
                this.idProvider = new UuidProvider();
                break;
            }
            default: {
                this.idProvider = new RandomIdProvider();
            }
        }
        this.idProvider.configure(configuration);
    }

    @Override
    public String newId() {
        return this.idProvider.newId();
    }

    @Override
    public String encodeUrl(RequestWithSession request, String url) {
        return url;
    }

    protected String clean(String value) {
        return this.idProvider.readId(value);
    }
}

