/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.RepositoryBackedSession;
import com.amadeus.session.RequestWithSession;
import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.SessionTracking;
import com.amadeus.session.servlet.BaseSessionTracking;
import com.amadeus.session.servlet.ServletLevel;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class CookieSessionTracking
extends BaseSessionTracking
implements SessionTracking {
    static final String COOKIE_CONTEXT_PATH_PARAMETER = "com.amadeus.session.cookie.contextPath";
    static final String SECURE_COOKIE_PARAMETER = "com.amadeus.session.cookie.secure";
    static final String COOKIE_HTTP_ONLY_PARAMETER = "com.amadeus.session.cookie.httpOnly";
    private boolean httpOnly = true;
    private boolean contextPath = false;
    private Boolean secure;

    CookieSessionTracking() {
    }

    @Override
    public String retrieveId(RequestWithSession request) {
        Cookie[] cookies = ((HttpServletRequest)request).getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.idName.equals(cookie.getName())) continue;
                return this.clean(cookie.getValue());
            }
        }
        return null;
    }

    @Override
    public void propagateSession(RequestWithSession request, Object response) {
        Cookie cookie = new Cookie(this.idName, "");
        RepositoryBackedSession session = request.getRepositoryBackedSession(false);
        if (session != null && !session.isValid()) {
            session = null;
        }
        if (session == null) {
            cookie.setMaxAge(0);
        } else {
            cookie.setValue(session.getId());
        }
        if (ServletLevel.isServlet3) {
            cookie.setHttpOnly(this.httpOnly);
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.secure.booleanValue()) {
            cookie.setSecure(httpRequest.isSecure());
        }
        cookie.setPath(this.cookiePath(httpRequest));
        ((HttpServletResponse)response).addCookie(cookie);
    }

    private String cookiePath(HttpServletRequest request) {
        return this.contextPath ? request.getContextPath() + "/" : "/";
    }

    @Override
    public void configure(SessionConfiguration conf) {
        super.configure(conf);
        this.httpOnly = Boolean.valueOf(conf.getAttribute(COOKIE_HTTP_ONLY_PARAMETER, "true"));
        this.secure = Boolean.valueOf(conf.getAttribute(SECURE_COOKIE_PARAMETER, "false"));
        this.contextPath = Boolean.valueOf(conf.getAttribute(COOKIE_CONTEXT_PATH_PARAMETER, "true"));
    }
}

