/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.ResponseWithSessionId;
import com.amadeus.session.servlet.HttpRequestWrapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class HttpResponseWrapper
extends HttpServletResponseWrapper
implements ResponseWithSessionId {
    private static final int LN_LENGTH = System.getProperty("line.separator").length();
    private final HttpRequestWrapper request;
    private ServletPrintWriter writer;
    private long contentWritten;
    protected long contentLength;
    private SaveSessionServletOutputStream outputStream;

    HttpResponseWrapper(HttpRequestWrapper request, HttpServletResponse response) {
        super(response);
        this.request = request;
    }

    public final void sendError(int sc) throws IOException {
        this.request.propagateSession();
        super.sendError(sc);
    }

    public final void sendError(int sc, String msg) throws IOException {
        this.request.propagateSession();
        super.sendError(sc, msg);
        this.closeOutput();
    }

    public final void sendRedirect(String location) throws IOException {
        this.request.propagateSession();
        super.sendRedirect(location);
        this.closeOutput();
    }

    public SaveSessionServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("Only one of getWriter()/getOutputStream() can be called, and writer is already used.");
        }
        if (this.outputStream == null) {
            this.outputStream = this.wrapOutputStream(super.getOutputStream());
        }
        return this.outputStream;
    }

    public ServletPrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("Only one of getWriter()/getOutputStream() can be called, and output stream is already used.");
        }
        if (this.writer == null) {
            this.writer = this.wrapPrintWriter();
        }
        return this.writer;
    }

    protected SaveSessionServletOutputStream wrapOutputStream(ServletOutputStream servletOutputStream) throws IOException {
        return new SaveSessionServletOutputStream(servletOutputStream);
    }

    private ServletPrintWriter wrapPrintWriter() throws IOException {
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
            this.setCharacterEncoding(encoding);
        }
        SaveSessionServletOutputStream wrappedStream = this.wrapOutputStream(super.getOutputStream());
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)((Object)wrappedStream), encoding);
        ServletPrintWriter myWriter = new ServletPrintWriter(osw);
        wrappedStream.setAssociated(myWriter);
        return myWriter;
    }

    public void addHeader(String name, String value) {
        this.checkContentLenghtHeader(name, value);
        super.addHeader(name, value);
    }

    void checkContentLenghtHeader(String name, String value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this.contentLength = Long.parseLong(value);
        }
    }

    public void setHeader(String name, String value) {
        this.checkContentLenghtHeader(name, value);
        super.setHeader(name, value);
    }

    public void setContentLength(int len) {
        this.contentLength = len;
        super.setContentLength(len);
    }

    private void checkContentLength(int contentLengthToWrite) throws IOException {
        boolean requiresFlush;
        this.contentWritten += (long)contentLengthToWrite;
        boolean isBodyFullyWritten = this.contentLength > 0L && this.contentWritten >= this.contentLength;
        int bufferSize = this.getBufferSize();
        boolean bl = requiresFlush = bufferSize > 0 && this.contentWritten >= (long)bufferSize;
        if (isBodyFullyWritten || requiresFlush) {
            this.flushAndPropagate();
        }
    }

    public void reset() {
        super.reset();
        this.request.removeAttribute("com.amadeus.session.isPropagated");
    }

    public String encodeURL(String url) {
        return this.request.encodeURL(url);
    }

    public void flushBuffer() throws IOException {
        this.flushAndPropagate();
        super.flushBuffer();
    }

    private void flushAndPropagate() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        } else if (this.writer != null) {
            this.writer.flush();
        } else {
            this.request.propagateSession();
        }
    }

    private void closeOutput() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    static class ServletPrintWriter
    extends PrintWriter {
        boolean closing;

        ServletPrintWriter(Writer out) {
            super(out);
        }

        @Override
        public void close() {
            if (!this.closing) {
                this.closing = true;
                super.close();
            }
        }
    }

    class SaveSessionServletOutputStream
    extends ServletOutputStream {
        protected final ServletOutputStream delegate;
        private Closeable associated;
        boolean closing;

        SaveSessionServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        void setAssociated(Closeable associated) {
            this.associated = associated;
        }

        public void write(int b) throws IOException {
            HttpResponseWrapper.this.checkContentLength(1);
            this.delegate.write(b);
        }

        public void flush() throws IOException {
            HttpResponseWrapper.this.request.propagateSession();
            this.delegate.flush();
        }

        public void close() throws IOException {
            if (this.closing) {
                return;
            }
            this.closing = true;
            if (this.associated != null) {
                this.associated.close();
            }
            HttpResponseWrapper.this.request.propagateSession();
            this.delegate.close();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public void print(boolean b) throws IOException {
            String s = String.valueOf(b);
            HttpResponseWrapper.this.checkContentLength(s.length());
            this.delegate.print(s);
        }

        public void print(char x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length());
            this.delegate.print(s);
        }

        public void print(double x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length());
            this.delegate.print(s);
        }

        public void print(float x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length());
            this.delegate.print(s);
        }

        public void print(int x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length());
            this.delegate.print(s);
        }

        public void print(long x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length());
            this.delegate.print(s);
        }

        public void print(String str) throws IOException {
            HttpResponseWrapper.this.checkContentLength(String.valueOf(str).length());
            this.delegate.print(str);
        }

        public void println() throws IOException {
            HttpResponseWrapper.this.checkContentLength(LN_LENGTH);
            this.delegate.println();
        }

        public void println(boolean x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length() + LN_LENGTH);
            this.delegate.println(s);
        }

        public void println(char x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length() + LN_LENGTH);
            this.delegate.println(s);
        }

        public void println(int x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length() + LN_LENGTH);
            this.delegate.println(s);
        }

        public void println(long x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length() + LN_LENGTH);
            this.delegate.println(s);
        }

        public void println(float x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length() + LN_LENGTH);
            this.delegate.println(s);
        }

        public void println(double x) throws IOException {
            String s = String.valueOf(x);
            HttpResponseWrapper.this.checkContentLength(s.length() + LN_LENGTH);
            this.delegate.println(s);
        }

        public void println(String str) throws IOException {
            str = String.valueOf(str);
            HttpResponseWrapper.this.checkContentLength(LN_LENGTH + str.length());
            this.delegate.println(str);
        }

        public void write(byte[] b) throws IOException {
            HttpResponseWrapper.this.checkContentLength(b.length);
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            HttpResponseWrapper.this.checkContentLength(len);
            this.delegate.write(b, off, len);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

