/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletContextDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(ServletContextDescriptor.class);
    private final HashSet<HttpSessionListener> httpSessionListenersSet = new HashSet();
    private final HashSet<HttpSessionAttributeListener> httpSessionAttributeListenersSet = new HashSet();
    private final HashSet<EventListener> httpSessionIdListenersSet = new HashSet();
    private final List<HttpSessionListener> httpSessionListeners = new ArrayList<HttpSessionListener>();
    private final List<HttpSessionAttributeListener> httpSessionAttributeListeners = new ArrayList<HttpSessionAttributeListener>();
    private final List<EventListener> httpSessionIdListeners = new ArrayList<EventListener>();
    private String contextPath;

    ServletContextDescriptor(ServletContext servletContext) {
        this.contextPath = servletContext.getContextPath();
    }

    void addHttpSessionListener(HttpSessionListener listener) {
        if (this.httpSessionListenersSet.add(listener)) {
            this.httpSessionListeners.add(listener);
            logger.info("Registered HttpSessionListener {} for context {}", (Object)listener, (Object)this.contextPath);
        }
    }

    void addHttpSessionAttributeListener(HttpSessionAttributeListener listener) {
        if (this.httpSessionAttributeListenersSet.add(listener)) {
            this.httpSessionAttributeListeners.add(listener);
            logger.info("Registered HttpSessionAttributeListener {} for context {}", (Object)listener, (Object)this.contextPath);
        }
    }

    void addHttpSessionIdListener(EventListener listener) {
        if (this.httpSessionIdListenersSet.add(listener)) {
            this.httpSessionIdListeners.add(listener);
            logger.info("Registered HttpSessionIdListener {} for context {}", (Object)listener, (Object)this.contextPath);
        }
    }

    List<HttpSessionListener> getHttpSessionListeners() {
        return this.httpSessionListeners;
    }

    List<HttpSessionAttributeListener> getHttpSessionAttributeListeners() {
        return this.httpSessionAttributeListeners;
    }

    List<EventListener> getHttpSessionIdListeners() {
        return this.httpSessionIdListeners;
    }
}

