/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.ExecutorFacade;
import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.SessionManager;
import com.amadeus.session.SessionRepository;
import com.amadeus.session.SessionRepositoryFactory;
import com.amadeus.session.SessionTracking;
import com.amadeus.session.repository.inmemory.InMemoryRepository;
import com.amadeus.session.servlet.Attributes;
import com.amadeus.session.servlet.HttpRequestWrapper;
import com.amadeus.session.servlet.HttpRequestWrapperServlet3;
import com.amadeus.session.servlet.HttpResponseWrapper;
import com.amadeus.session.servlet.HttpResponseWrapper31;
import com.amadeus.session.servlet.HttpSessionFactory;
import com.amadeus.session.servlet.HttpSessionNotifier;
import com.amadeus.session.servlet.RepositoryBackedHttpSession;
import com.amadeus.session.servlet.ServletContextDescriptor;
import com.amadeus.session.servlet.ServletLevel;
import com.amadeus.session.servlet.SessionFilter;
import com.amadeus.session.servlet.SessionPropagation;
import com.amadeus.session.servlet.ShutdownListener;
import com.amadeus.session.servlet.WebXmlParser;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionHelpers {
    private static final Logger logger = LoggerFactory.getLogger(SessionHelpers.class);
    static final String DUMMY_ATTRIBUTE = "com.amadeus.session.dummy";
    static final String SESSION_HELPER_METHODS = "com.amadeus.session.servlet.SessionHelpers.methods";
    static final String DEFAULT_REPOSITORY_FACTORY = "com.amadeus.session.repository.inmemory.InMemoryRepositoryFactory";
    static final String INTROSPECTING_LISTENERS = "com.amadeus.session.introspected.listeners";
    static final String REQUEST_WRAPPED_ATTRIBUTE = HttpRequestWrapper.class.getName();
    static final String SESSION_CONFIGURATION = SessionConfiguration.class.getName();
    static final String SESSION_HELPERS = SessionHelpers.class.getName();
    private boolean interceptListeners;

    public ServletRequest prepareRequest(ServletRequest request, ServletResponse response, ServletContext originalServletContext) {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpRequestWrapper wrappedRequest = (HttpRequestWrapper)request.getAttribute(REQUEST_WRAPPED_ATTRIBUTE);
            ServletContext servletContext = originalServletContext;
            if (servletContext == null) {
                logger.info("ServletContext was null when prepareRequest() was called from Filter. This means that filter's init() method was not called at initialization time. This may result in unexpected behavior if this filter was invoked afterservlet dispatch forward() and include() calls.");
                servletContext = ((HttpServletRequest)request).getServletContext();
            }
            if (wrappedRequest == null || servletContext != wrappedRequest.getServletContext()) {
                if (this.interceptListeners) {
                    SessionHelpers.findListenersByIntercepting(servletContext, (HttpServletRequest)request);
                }
                wrappedRequest = SessionHelpers.wrapRequest(request, servletContext);
                wrappedRequest.setResponse(SessionHelpers.wrapResponse(response, wrappedRequest));
                request.setAttribute(REQUEST_WRAPPED_ATTRIBUTE, (Object)wrappedRequest);
                return wrappedRequest;
            }
        }
        return request;
    }

    private static HttpResponseWrapper wrapResponse(ServletResponse response, HttpRequestWrapper wrappedRequest) {
        if (ServletLevel.isServlet31) {
            return new HttpResponseWrapper31(wrappedRequest, (HttpServletResponse)response);
        }
        return new HttpResponseWrapper(wrappedRequest, (HttpServletResponse)response);
    }

    private static HttpRequestWrapper wrapRequest(ServletRequest request, ServletContext servletContext) {
        if (ServletLevel.isServlet3) {
            return new HttpRequestWrapperServlet3((HttpServletRequest)request, servletContext);
        }
        return new HttpRequestWrapper((HttpServletRequest)request, servletContext);
    }

    public ServletResponse prepareResponse(ServletRequest request, ServletResponse response) {
        if (request instanceof HttpRequestWrapper) {
            return ((HttpRequestWrapper)request).getResponse();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodHandle[] initSessionManagement(ServletContext servletContext) {
        MethodHandle[] methods = (MethodHandle[])servletContext.getAttribute(SESSION_HELPER_METHODS);
        if (methods == null) {
            SessionHelpers sessionHelpers = this;
            synchronized (sessionHelpers) {
                methods = this.prepareMethodCalls(servletContext);
            }
            servletContext.setAttribute(SESSION_HELPERS, (Object)this);
            ServletContextDescriptor scd = this.getDescriptor(servletContext);
            SessionHelpers.setupContext(servletContext);
            HttpSessionNotifier notifier = new HttpSessionNotifier(scd);
            HttpSessionFactory factory = new HttpSessionFactory(servletContext);
            SessionConfiguration conf = SessionHelpers.initConf(servletContext);
            SessionRepository repository = SessionHelpers.repository(servletContext, conf);
            SessionTracking tracking = SessionHelpers.getTracking(servletContext, conf);
            ExecutorFacade executors = new ExecutorFacade(conf);
            ClassLoader classLoader = SessionHelpers.classLoader(servletContext);
            SessionManager sessionManagement = new SessionManager(executors, factory, repository, tracking, notifier, conf, classLoader);
            this.interceptListeners = conf.isInterceptListeners();
            servletContext.setAttribute(Attributes.SESSION_MANAGER, (Object)sessionManagement);
        }
        return methods;
    }

    private MethodHandle[] prepareMethodCalls(ServletContext servletContext) {
        try {
            MethodHandle[] methods = (MethodHandle[])servletContext.getAttribute(SESSION_HELPER_METHODS);
            if (methods != null) {
                return methods;
            }
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType mt = MethodType.methodType(Void.TYPE, ServletContext.class, Object.class);
            MethodHandle onAddListner = lookup.bind(this, "onAddListener", mt);
            mt = MethodType.methodType(Void.TYPE, EventListener.class, HttpSessionEvent.class);
            MethodHandle interceptHttpListener = lookup.bind(this, "interceptHttpListener", mt);
            mt = MethodType.methodType(MethodHandle[].class, ServletContext.class);
            MethodHandle initSessionManagement = lookup.bind(this, "initSessionManagement", mt);
            mt = MethodType.methodType(ServletResponse.class, ServletRequest.class, ServletResponse.class);
            MethodHandle prepareResponse = lookup.bind(this, "prepareResponse", mt);
            mt = MethodType.methodType(ServletRequest.class, ServletRequest.class, ServletResponse.class, ServletContext.class);
            MethodHandle prepareRequest = lookup.bind(this, "prepareRequest", mt);
            mt = MethodType.methodType(Void.TYPE, ServletRequest.class, ServletRequest.class);
            MethodHandle commitRequest = lookup.bind(this, "commitRequest", mt);
            methods = new MethodHandle[]{onAddListner, interceptHttpListener, initSessionManagement, prepareResponse, prepareRequest, commitRequest};
            servletContext.setAttribute(SESSION_HELPER_METHODS, (Object)methods);
            return methods;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("Unable to introspect class " + SessionHelpers.class, e);
        }
    }

    static SessionTracking getTracking(ServletContext servletContext, SessionConfiguration sessionConfiguration) {
        String sessionTracking = sessionConfiguration.getSessionTracking();
        try {
            SessionTracking instance;
            if (sessionTracking == null) {
                instance = SessionPropagation.DEFAULT.get();
            } else {
                instance = SessionHelpers.trackingFromEnum(sessionTracking);
                if (instance == null) {
                    instance = (SessionTracking)SessionHelpers.newInstance(servletContext, sessionTracking);
                }
            }
            instance.configure(sessionConfiguration);
            return instance;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to load or instantiate SessionTracking class " + sessionTracking, e);
        }
    }

    static SessionTracking trackingFromEnum(String sessionTracking) throws InstantiationException, IllegalAccessException {
        try {
            SessionPropagation sp = SessionPropagation.valueOf(sessionTracking);
            return sp.get();
        }
        catch (IllegalArgumentException e) {
            logger.debug("The argument for session propagation was not enumration, it is probably class name: {}, message: {}", (Object)sessionTracking, (Object)e);
            return null;
        }
    }

    static SessionRepository repository(ServletContext servletContext, SessionConfiguration conf) {
        Map providers;
        String repositoryFactoryId = conf.getRepositoryFactory();
        if (repositoryFactoryId == null) {
            repositoryFactoryId = DEFAULT_REPOSITORY_FACTORY;
        }
        String repositoryFactory = (providers = (Map)servletContext.getAttribute("com.amadeus.session.providers")) != null && providers.containsKey(repositoryFactoryId) ? (String)providers.get(repositoryFactoryId) : repositoryFactoryId;
        try {
            return SessionHelpers.repositoryOrDefault(repositoryFactory, servletContext, conf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Unable to load or instantiate SessionRepositoryFactory. Id=" + repositoryFactoryId + ", Implementation=" + repositoryFactory, e);
        }
    }

    static SessionRepository repositoryOrDefault(String repositoryFactory, ServletContext context, SessionConfiguration conf) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        SessionRepositoryFactory instance = (SessionRepositoryFactory)SessionHelpers.newInstance(context, repositoryFactory);
        if (!conf.isDistributable() && instance.isDistributed()) {
            if (!conf.isForceDistributable()) {
                logger.info("Web application {} was not marked distrubutablem using InMemoryRepository.", (Object)context.getContextPath());
                return new InMemoryRepository(conf.getNamespace());
            }
            logger.warn("Web application {} was not marked distributable, but the repository factory {} enforces distribution.", (Object)context.getContextPath(), (Object)instance);
        }
        return instance.repository(conf);
    }

    private static Object newInstance(ServletContext servletContext, String implementationClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = SessionHelpers.classLoader(servletContext).loadClass(implementationClass);
        return clazz.newInstance();
    }

    private static ClassLoader classLoader(ServletContext servletContext) {
        ClassLoader classLoader;
        if (ServletLevel.isServlet3 && (classLoader = servletContext.getClassLoader()) != null) {
            return classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    static SessionConfiguration initConf(final ServletContext context) {
        SessionConfiguration sessionConfiguration = (SessionConfiguration)context.getAttribute(SESSION_CONFIGURATION);
        if (sessionConfiguration == null) {
            sessionConfiguration = new SessionConfiguration();
            context.setAttribute(SESSION_CONFIGURATION, (Object)sessionConfiguration);
            WebXmlParser.parseWebXml(sessionConfiguration, context);
            sessionConfiguration.initializeFrom(new SessionConfiguration.AttributeProvider(){

                @Override
                public String getAttribute(String key) {
                    return context.getInitParameter(key);
                }

                @Override
                public Object source() {
                    return context.getContextPath();
                }
            });
            if (sessionConfiguration.getTrueNamespace() == null) {
                sessionConfiguration.setNamespace(context.getContextPath());
            }
        }
        return sessionConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitRequest(ServletRequest request, ServletRequest oldRequest) {
        if (request != oldRequest && request instanceof HttpRequestWrapper) {
            HttpRequestWrapper httpRequestWrapper = (HttpRequestWrapper)request;
            try {
                httpRequestWrapper.commit();
            }
            catch (Exception e) {
                logger.error("An exception occured while commiting the session.", (Throwable)e);
            }
            finally {
                request.setAttribute(REQUEST_WRAPPED_ATTRIBUTE, (Object)httpRequestWrapper.getEmbeddedRequest());
            }
        }
    }

    static void findListenersByIntercepting(ServletContext context, HttpServletRequest request) {
        if (context.getAttribute(INTROSPECTING_LISTENERS) == null) {
            logger.info("Started collecting servlet listeners.");
            context.setAttribute(INTROSPECTING_LISTENERS, new HashSet());
            HttpSession session = request.getSession();
            session.setAttribute(DUMMY_ATTRIBUTE, (Object)DUMMY_ATTRIBUTE);
            session.removeAttribute(DUMMY_ATTRIBUTE);
            session.invalidate();
            context.setAttribute(INTROSPECTING_LISTENERS, (Object)Boolean.TRUE);
            logger.info("Finished collecting listeners.");
        }
    }

    public void interceptHttpListener(EventListener caller, HttpSessionEvent event) {
        if (event.getSession() instanceof RepositoryBackedHttpSession) {
            return;
        }
        Object value = event.getSession().getServletContext().getAttribute(INTROSPECTING_LISTENERS);
        if (value != null && !((Set)value).contains(caller)) {
            ((Set)value).add(caller);
            this.onAddListener(event.getSession().getServletContext(), caller);
        }
    }

    private ServletContextDescriptor getDescriptor(ServletContext servletContext) {
        ServletContextDescriptor scd = (ServletContextDescriptor)servletContext.getAttribute(Attributes.SERVLET_CONTEXT_DESCRIPTOR);
        if (scd == null) {
            scd = new ServletContextDescriptor(servletContext);
            servletContext.setAttribute(Attributes.SERVLET_CONTEXT_DESCRIPTOR, (Object)scd);
            logger.info("Registered servlet context {}.", (Object)servletContext.getContextPath());
        }
        return scd;
    }

    public void onAddListener(ServletContext servletContext, Object listener) {
        String contextPath = servletContext.getContextPath();
        ServletContextDescriptor scd = this.getDescriptor(servletContext);
        logger.debug("Registering listener {} for context {}", listener, (Object)contextPath);
        if (listener instanceof HttpSessionListener) {
            scd.addHttpSessionListener((HttpSessionListener)listener);
        }
        if (listener instanceof HttpSessionAttributeListener) {
            scd.addHttpSessionAttributeListener((HttpSessionAttributeListener)listener);
        }
        if (ServletLevel.isServlet31 && listener instanceof HttpSessionIdListener) {
            scd.addHttpSessionIdListener((EventListener)((HttpSessionIdListener)listener));
        }
    }

    static void setupContext(ServletContext context) {
        if (ServletLevel.isServlet3) {
            FilterRegistration.Dynamic reg = context.addFilter("com.amdeus.session.filter", (Filter)new SessionFilter());
            if (reg != null) {
                reg.addMappingForUrlPatterns(null, false, new String[]{"/*"});
            }
            context.addListener((EventListener)((Object)new ShutdownListener()));
        }
    }
}

