/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.RepositoryBackedSession;
import com.amadeus.session.RequestWithSession;
import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.SessionTracking;
import com.amadeus.session.servlet.BaseSessionTracking;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;

public class UrlSessionTracking
extends BaseSessionTracking
implements SessionTracking {
    private String sessionIdPathItem;

    @Override
    public void configure(SessionConfiguration configuration) {
        super.configure(configuration);
        this.sessionIdPathItem = ";" + this.idName + '=';
    }

    @Override
    public String retrieveId(RequestWithSession request) {
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        int sessionIdStart = pathInfo.lastIndexOf(this.sessionIdPathItem);
        if (sessionIdStart > -1) {
            String sessionId = pathInfo.substring(sessionIdStart += this.sessionIdPathItem.length());
            return this.clean(sessionId);
        }
        return null;
    }

    @Override
    public void propagateSession(RequestWithSession request, Object response) {
    }

    @Override
    public String encodeUrl(RequestWithSession request, String url) {
        String encodedSessionAlias;
        RepositoryBackedSession session = request.getRepositoryBackedSession(false);
        if (session == null || !session.isValid()) {
            return url;
        }
        try {
            encodedSessionAlias = URLEncoder.encode(session.getId(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("This exception should never happen!", e);
        }
        int queryStart = url.indexOf(63);
        if (queryStart < 0) {
            return url + this.sessionIdPathItem + encodedSessionAlias;
        }
        String path = url.substring(0, queryStart);
        String query = url.substring(queryStart + 1, url.length());
        path = path + this.sessionIdPathItem + encodedSessionAlias;
        return path + '?' + query;
    }
}

