/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.servlet.SessionPropagation;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class WebXmlParser {
    private static final Logger logger = LoggerFactory.getLogger(WebXmlParser.class);

    private WebXmlParser() {
    }

    static void parseWebXml(SessionConfiguration conf, ServletContext context) {
        InputStream is = context.getResourceAsStream("/WEB-INF/web.xml");
        WebXmlParser.parseStream(conf, is);
    }

    static void parseStream(SessionConfiguration conf, InputStream is) {
        if (is != null) {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                builder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(new StringReader(""));
                    }
                });
                Document document = builder.parse(is);
                XPath xpath = XPathFactory.newInstance().newXPath();
                WebXmlParser.lookForSessionTimeout(conf, document, xpath);
                WebXmlParser.lookForSessionConf(conf, document, xpath);
                WebXmlParser.checkDistributable(conf, document, xpath);
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new IllegalStateException("An exception occured while parsing web.xml. Using default configuration: " + conf, e);
            }
        }
    }

    private static void checkDistributable(SessionConfiguration conf, Document document, XPath xpath) throws XPathExpressionException {
        if (xpath.evaluate("/web-app/distributable", document, XPathConstants.NODE) != null) {
            conf.setDistributable(true);
        }
    }

    private static void lookForSessionTimeout(SessionConfiguration conf, Document document, XPath xpath) throws XPathExpressionException {
        String timeoutAsString = xpath.evaluate("/web-app/session-config/session-timeout/text()", document);
        if (WebXmlParser.isNonEmpty(timeoutAsString)) {
            conf.setMaxInactiveInterval(Integer.parseInt(timeoutAsString));
        }
    }

    private static void lookForSessionConf(SessionConfiguration sessionConfiguration, Document document, XPath xpath) throws XPathExpressionException {
        String trackingMode;
        String secure;
        String httpOnlyString = xpath.evaluate("/web-app/session-config/cookie-config/http-only/text()", document);
        if (WebXmlParser.isNonEmpty(httpOnlyString)) {
            sessionConfiguration.setAttribute("com.amadeus.session.cookie.httpOnly", httpOnlyString);
        }
        if (WebXmlParser.isNonEmpty(secure = xpath.evaluate("/web-app/session-config/cookie-config/secure/text()", document))) {
            sessionConfiguration.setAttribute("com.amadeus.session.cookie.secure", secure);
        }
        if (WebXmlParser.isNonEmpty(trackingMode = xpath.evaluate("/web-app/session-config/tracking-mode/text()", document))) {
            sessionConfiguration.setSessionTracking(WebXmlParser.sessionTracking(trackingMode));
        }
    }

    private static String sessionTracking(String trackingMode) {
        if ("COOKIE".equalsIgnoreCase(trackingMode)) {
            return SessionPropagation.COOKIE.name();
        }
        if ("URL".equalsIgnoreCase(trackingMode)) {
            return SessionPropagation.URL.name();
        }
        logger.warn("Unsupported session tracking mode {}. Will be using default one.", (Object)trackingMode);
        return SessionPropagation.DEFAULT.name();
    }

    private static boolean isNonEmpty(String value) {
        return value != null && !value.isEmpty();
    }
}

