/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.slf4j.ILoggerFactory;
import org.slf4j.impl.SimpleLoggerFactory;
import org.slf4j.spi.LoggerFactoryBinder;

public final class StaticLoggerBinder
implements LoggerFactoryBinder {
    private static final StaticLoggerBinder SINGLETON;
    public static String REQUESTED_API_VERSION;
    private static final String loggerFactoryClassStr;
    static final String mdcAdapterClassStr;
    private final ILoggerFactory loggerFactory;

    public static final StaticLoggerBinder getSingleton() {
        return SINGLETON;
    }

    private StaticLoggerBinder() {
        ILoggerFactory lf;
        try {
            lf = (ILoggerFactory)Class.forName(loggerFactoryClassStr).newInstance();
        }
        catch (Exception e) {
            System.err.println("Unable to instantiate logger factory " + loggerFactoryClassStr);
            e.printStackTrace();
            lf = new SimpleLoggerFactory();
        }
        this.loggerFactory = lf;
    }

    public ILoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getLoggerFactoryClassStr() {
        return loggerFactoryClassStr;
    }

    static {
        String mdca;
        String lfc;
        try {
            Class.forName("org.apache.log4j.Logger");
            lfc = "org.slf4j.impl.Log4jLoggerFactory";
            mdca = "org.slf4j.impl.Log4jMDCAdapter";
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.apache.commons.logging.Log");
                lfc = "org.slf4j.impl.JCLLoggerFactory";
                mdca = "org.slf4j.helpers.NOPMDCAdapter";
            }
            catch (ClassNotFoundException e1) {
                try {
                    Class.forName("java.util.logging.Logger");
                    lfc = "org.slf4j.impl.JDK14LoggerFactory";
                    mdca = "org.slf4j.helpers.BasicMDCAdapter";
                }
                catch (ClassNotFoundException e2) {
                    lfc = "org.slf4j.impl.SimpleLoggerFactory";
                    mdca = "org.slf4j.helpers.NOPMDCAdapter";
                }
            }
        }
        loggerFactoryClassStr = lfc;
        mdcAdapterClassStr = mdca;
        SINGLETON = new StaticLoggerBinder();
        REQUESTED_API_VERSION = "1.6.99";
    }
}

