/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session;

import com.amadeus.session.RepositoryBackedSession;
import com.amadeus.session.SessionData;
import com.amadeus.session.SessionFactory;
import com.amadeus.session.SessionManager;
import com.amadeus.session.shaded.org.slf4j.Logger;
import com.amadeus.session.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultSessionFactory
implements SessionFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSessionFactory.class);
    protected SessionManager sessionManager;
    private ConcurrentHashMap<String, RepositoryBackedSession> cachedSessions;
    private boolean useCached;

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.useCached = sessionManager.getConfiguration().isAllowedCachedSessionReuse();
        if (this.useCached) {
            this.cachedSessions = new ConcurrentHashMap();
        }
    }

    @Override
    public RepositoryBackedSession build(SessionData sessionData) {
        if (this.useCached) {
            RepositoryBackedSession session = this.cachedSessions.get(sessionData.getId());
            if (session == null) {
                session = this.newSessionObject(sessionData);
                RepositoryBackedSession oldSession = this.cachedSessions.putIfAbsent(sessionData.getId(), session);
                if (oldSession != null) {
                    session = this.wrapSession(oldSession);
                }
            } else {
                session = this.wrapSession(session);
            }
            return session;
        }
        return this.newSessionObject(sessionData);
    }

    protected RepositoryBackedSession wrapSession(RepositoryBackedSession oldSession) {
        return new RepositoryBackedSession(oldSession);
    }

    protected RepositoryBackedSession newSessionObject(SessionData sessionData) {
        return new RepositoryBackedSession(sessionData, this.sessionManager, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void committed(RepositoryBackedSession session) {
        if (this.useCached) {
            RepositoryBackedSession repositoryBackedSession = session;
            synchronized (repositoryBackedSession) {
                if (session.getConcurrentUses() <= 0) {
                    this.cachedSessions.remove(session.getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionIdChange(SessionData sessionData) {
        if (this.useCached) {
            RepositoryBackedSession session = this.cachedSessions.remove(sessionData.getOriginalId());
            if (session != null) {
                SessionData cachedSessionData = session.getSessionData();
                if (cachedSessionData != sessionData) {
                    SessionData sessionData2 = cachedSessionData;
                    synchronized (sessionData2) {
                        if (cachedSessionData.isIdChanged()) {
                            logger.warn("Session id was already switched for session in cache: {}, new session should be: {}", (Object)cachedSessionData, (Object)sessionData);
                            return;
                        }
                        cachedSessionData.setNewSessionId(sessionData.getId());
                    }
                }
                this.cachedSessions.put(sessionData.getId(), session);
            } else {
                logger.warn("Session id during session id change was not present in the cache: {}.", (Object)sessionData);
            }
        }
    }
}

