/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session;

import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.shaded.com.codahale.metrics.Gauge;
import com.amadeus.session.shaded.com.codahale.metrics.MetricRegistry;
import com.amadeus.session.shaded.org.slf4j.Logger;
import com.amadeus.session.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ExecutorFacade
implements Thread.UncaughtExceptionHandler,
ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorFacade.class);
    private static final String THREAD_JNDI = "com.amadeus.session.thread.jndi";
    private static final String WORK_QUEUE_SIZE = "com.amadeus.session.thread.queue";
    private static final String METRIC_PREFIX = "com.amadeus.session";
    private static final int WAIT_FOR_SHUTDOWN = 10;
    private static final int CORE_THREADS_IN_POOL = 4;
    private static final int SCHEDULER_THREADS_IN_POOL = 2;
    private static final int THREAD_KEEPALIVE_TIME = 10;
    private static final int MAXIMUM_THREADS_IN_POOL = 40;
    private static final String MAXIMUM_WORK_QUEUE_SIZE = String.valueOf(100);
    private final ThreadPoolExecutor executor;
    private final ScheduledThreadPoolExecutor scheduledExecutor;
    private final ThreadFactory baseThreadFactory;
    private final String namespace;
    private final AtomicLong count = new AtomicLong(0L);

    public ExecutorFacade(SessionConfiguration conf) {
        ThreadFactory tf;
        this.namespace = conf.getNamespace();
        String threadFactoryJndi = conf.getAttribute(THREAD_JNDI, "java:comp/DefaultManagedThreadFactory");
        try {
            tf = (ThreadFactory)InitialContext.doLookup(threadFactoryJndi);
        }
        catch (NamingException e) {
            logger.warn("Unable to use ManagedThreadFactory from JNDI {}, using built-in thread pool. Cause: '{}'. Activate debug tracing for more information.", (Object)threadFactoryJndi, (Object)e.getMessage());
            logger.debug("Unable to use ManagedThreadFactory from JNDI, stack trace follows. ", e);
            tf = Executors.defaultThreadFactory();
        }
        this.baseThreadFactory = tf;
        int queueSize = Integer.parseInt(conf.getAttribute(WORK_QUEUE_SIZE, MAXIMUM_WORK_QUEUE_SIZE));
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(queueSize);
        this.executor = new ThreadPoolExecutor(4, 40, 10L, TimeUnit.SECONDS, workQueue, this, new ThreadPoolExecutor.CallerRunsPolicy());
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(2, this, new DiscardAndLog());
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.baseThreadFactory.newThread(r);
        thread.setName("pool-" + this.namespace + "-" + this.count.getAndIncrement());
        thread.setUncaughtExceptionHandler(this);
        return thread;
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    void startMetrics(MetricRegistry metrics) {
        this.monitorTreadPoolExecutor(MetricRegistry.name(METRIC_PREFIX, "threads"), this.executor, metrics);
        this.monitorTreadPoolExecutor(MetricRegistry.name(METRIC_PREFIX, "scheduled-threads"), this.scheduledExecutor, metrics);
        metrics.register(MetricRegistry.name(METRIC_PREFIX, "scheduled-threads", "tasks"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                return ExecutorFacade.this.scheduledExecutor.getTaskCount();
            }
        });
    }

    private void monitorTreadPoolExecutor(String name, final ThreadPoolExecutor pool, MetricRegistry metrics) {
        metrics.register(MetricRegistry.name(name, "active"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return pool.getActiveCount();
            }
        });
        metrics.register(MetricRegistry.name(name, "largest"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return pool.getLargestPoolSize();
            }
        });
        metrics.register(MetricRegistry.name(name, "pool"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return pool.getPoolSize();
            }
        });
        metrics.register(MetricRegistry.name(name, "waiting"), new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return pool.getQueue().size();
            }
        });
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        logger.error("Uncaught exeception occured while execting thread ", (Object)t, (Object)e);
        if (e instanceof Error) {
            throw (Error)e;
        }
    }

    public void shutdown() {
        logger.info("Shutting down the executor.");
        this.executor.shutdown();
        this.scheduledExecutor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            this.scheduledExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Task termination thread was interrupted.", e);
        }
    }

    static class DiscardAndLog
    implements RejectedExecutionHandler {
        DiscardAndLog() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            logger.error("Discarding submitted task: {}", (Object)r);
        }
    }
}

