/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session;

import com.amadeus.session.SessionData;
import com.amadeus.session.SessionFactory;
import com.amadeus.session.SessionManager;
import com.amadeus.session.SessionRepository;
import com.amadeus.session.shaded.org.slf4j.Logger;
import com.amadeus.session.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RepositoryBackedSession {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryBackedSession.class);
    private boolean invalid;
    private boolean invalidateOnCommit;
    private final SessionData sessionData;
    private final Committer committer;
    private final AtomicInteger concurrentUses;
    private final AtomicBoolean lockedForUse;
    private final boolean forceCommit;
    protected final SessionManager manager;
    private final boolean replicateOnGet;
    protected final ConcurrentHashMap<String, Attribute> attrs;
    private boolean dirty;
    private boolean committed;
    private SessionFactory factory;

    public RepositoryBackedSession(SessionData sessionData, SessionManager manager, SessionFactory factory) {
        this.sessionData = sessionData;
        this.manager = manager;
        this.factory = factory;
        this.committed = false;
        this.concurrentUses = new AtomicInteger();
        this.lockedForUse = new AtomicBoolean();
        this.committer = new Committer();
        this.attrs = new ConcurrentHashMap();
        this.replicateOnGet = manager.getConfiguration().getReplicationTrigger().isReplicateOnGet();
        this.forceCommit = manager.getConfiguration().isCommitOnAllConcurrent();
    }

    protected RepositoryBackedSession(RepositoryBackedSession linked) {
        this.attrs = linked.attrs;
        this.concurrentUses = linked.concurrentUses;
        this.lockedForUse = new AtomicBoolean();
        this.manager = linked.getSessionManager();
        this.sessionData = linked.sessionData;
        this.factory = linked.factory;
        this.committed = false;
        this.committer = new Committer();
        this.replicateOnGet = this.manager.getConfiguration().getReplicationTrigger().isReplicateOnGet();
        this.forceCommit = this.manager.getConfiguration().isCommitOnAllConcurrent();
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.sessionData.setMaxInactiveInterval(maxInactiveInterval);
    }

    public Object getAttribute(String key) {
        this.assertValid();
        Attribute attr = this.retrieveAttribute(key, this.getAttributeFromCache(key));
        if (attr == null || attr.deleted) {
            return null;
        }
        if (this.replicateOnGet(attr.value)) {
            attr.changed = true;
            this.dirty = true;
            this.checkUsedAndLock();
        }
        return attr.value;
    }

    boolean replicateOnGet(Object obj) {
        return this.replicateOnGet && !RepositoryBackedSession.isImmutableType(obj);
    }

    static boolean isImmutableType(Object obj) {
        return obj instanceof Number || obj instanceof Character || obj instanceof String || obj instanceof Boolean || obj instanceof Enum;
    }

    public Enumeration getAttributeNames() {
        this.assertValid();
        List<String> keys = this.getAttributeNamesWithValues();
        for (String key : this.getAllRepositoryKeys()) {
            if (this.attrs.containsKey(key)) continue;
            keys.add(key);
        }
        return Collections.enumeration(keys);
    }

    public List<String> getAttributeNamesWithValues() {
        ArrayList<String> keys = new ArrayList<String>(this.attrs.size());
        for (Map.Entry<String, Attribute> entry : this.attrs.entrySet()) {
            if (entry.getValue().value == null) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public long getCreationTime() {
        this.assertValid();
        return this.sessionData.getCreationTime();
    }

    public String getId() {
        this.assertValid();
        return this.sessionData.getId();
    }

    public long getLastAccessedTime() {
        this.assertValid();
        return this.sessionData.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        this.assertValid();
        return this.sessionData.getMaxInactiveInterval();
    }

    public void invalidate() {
        this.assertValid();
        this.doInvalidate(false);
    }

    public void doInvalidate(boolean expired) {
        boolean canRemove = false;
        try {
            if (!this.invalid) {
                canRemove = this.invalidateOrNotify(expired);
            }
        }
        finally {
            if (!this.invalidateOnCommit) {
                this.finishInvalidation(canRemove);
            }
        }
    }

    private boolean invalidateOrNotify(boolean expired) {
        boolean canRemove = this.manager.getRepository().prepareRemove(this.getSessionData());
        if (canRemove) {
            if (expired && this.isUsed()) {
                this.invalidateOnCommit = true;
            } else {
                this.invalidateOnCommit = false;
                this.wipeInvalidSession();
            }
        } else {
            this.manager.invalidationConflict(this, expired);
        }
        return canRemove;
    }

    private boolean isUsed() {
        return this.concurrentUses.get() > 0;
    }

    void wipeInvalidSession() {
        this.loadAllAttributes();
        this.manager.getNotifier().sessionDestroyed(this, false);
        this.attrs.clear();
    }

    private void finishInvalidation(boolean canRemove) {
        this.invalid = true;
        if (canRemove) {
            this.manager.remove(this.sessionData);
        }
    }

    private Set<String> getAllRepositoryKeys() {
        Set<String> set = this.sessionData.getRepositoryKeys();
        if (set == null) {
            set = this.manager.getRepository().getAllKeys(this.sessionData);
            this.sessionData.setRepositoryKeys(set);
        }
        return set;
    }

    private void loadAllAttributes() {
        for (String key : this.getAllRepositoryKeys()) {
            if (this.getAttributeFromCache(key) != null) continue;
            this.retrieveAttribute(key, null);
        }
    }

    private Attribute retrieveAttribute(String key, Attribute attribute) {
        Attribute attr = attribute;
        if (attr != null && !this.sessionData.isNonCacheable(key)) {
            return attr;
        }
        if (attr == null && !this.sessionData.isMaybeInRepository(key)) {
            return null;
        }
        Object value = this.manager.getRepository().getSessionAttribute(this.sessionData, key);
        if (attr == null) {
            attr = new Attribute(value);
            this.attrs.put(key, attr);
        } else {
            attr.value = value;
        }
        if (value != null) {
            this.manager.getNotifier().attributeHasBeenRestored(this, key, value);
        }
        return attr;
    }

    public boolean isNew() {
        this.assertValid();
        return this.sessionData.isNew();
    }

    public void removeAttribute(String name) {
        this.assertValid();
        Attribute attr = this.getAttributeFromCache(name);
        if (attr == null && (attr = this.retrieveAttribute(name, null)) == null) {
            return;
        }
        if (this.sessionData.isNonCacheable(name)) {
            this.manager.getRepository().removeSessionAttribute(this.sessionData, name);
        }
        Object oldValue = attr.value;
        attr.value = null;
        attr.deleted = true;
        attr.changed = true;
        this.dirty = true;
        this.checkUsedAndLock();
        if (oldValue != null) {
            this.manager.getNotifier().attributeRemoved(this, name, oldValue);
        }
    }

    public Attribute getAttributeFromCache(String name) {
        return this.attrs.get(name);
    }

    public void setAttribute(String key, Object value) {
        Object oldValue;
        Attribute attr;
        this.assertValid();
        if (value == null) {
            this.removeAttribute(key);
            return;
        }
        if (this.sessionData.isNonCacheable(key)) {
            this.manager.getRepository().setSessionAttribute(this.sessionData, key, value);
            attr = this.getAttributeFromCache(key);
        } else {
            attr = this.retrieveAttribute(key, this.getAttributeFromCache(key));
        }
        if (attr == null) {
            attr = new Attribute(value);
            this.attrs.put(key, attr);
            oldValue = null;
        } else {
            oldValue = attr.value;
            attr.value = value;
            attr.deleted = false;
        }
        attr.changed = true;
        this.dirty = true;
        this.checkUsedAndLock();
        if (oldValue != value) {
            if (oldValue != null) {
                this.manager.getNotifier().attributeReplaced(this, key, oldValue);
            }
            this.manager.getNotifier().attributeAdded(this, key, value);
        }
    }

    private void assertValid() {
        if (this.invalid) {
            throw new IllegalStateException("Session with id " + this.sessionData.getId() + " is invalid. Operation is not allowed. For information session data is " + this.sessionData);
        }
    }

    public synchronized void commit() {
        if (!this.invalid) {
            this.manager.invokeCommit(this);
        }
    }

    boolean checkUsedAndLock() {
        boolean used;
        boolean bl = used = !this.isCommitted() || this.dirty;
        if (used && this.lockedForUse.compareAndSet(false, true)) {
            this.concurrentUses.incrementAndGet();
        }
        return used;
    }

    protected void committed() {
        this.setCommitted(true);
        this.factory.committed(this);
    }

    public boolean isValid() {
        return !this.invalid;
    }

    public boolean isExpired() {
        int maxInactiveInterval = this.sessionData.getMaxInactiveInterval();
        if (maxInactiveInterval <= 0) {
            return false;
        }
        long instanceOfExpiring = this.sessionData.getLastAccessedTime() + TimeUnit.SECONDS.toMillis(maxInactiveInterval);
        return instanceOfExpiring < System.currentTimeMillis();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Runnable getCommitter() {
        return this.committer;
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    public int getConcurrentUses() {
        return this.concurrentUses.get();
    }

    class Committer
    implements Runnable {
        Committer() {
        }

        @Override
        public void run() {
            if (RepositoryBackedSession.this.checkUsedAndLock()) {
                boolean commitAttributes;
                boolean lastSession = this.unlockSession();
                boolean keepChangedFlag = !lastSession;
                boolean bl = commitAttributes = lastSession || RepositoryBackedSession.this.forceCommit;
                if (lastSession && RepositoryBackedSession.this.invalidateOnCommit) {
                    this.invalidationOnCommit();
                } else {
                    this.storeToRepository(commitAttributes, keepChangedFlag);
                }
                RepositoryBackedSession.this.committed();
                RepositoryBackedSession.this.dirty = false;
                logger.debug("Committed session: {}", (Object)RepositoryBackedSession.this.sessionData);
            } else {
                logger.debug("Nothing to commit for session: {}", (Object)RepositoryBackedSession.this.sessionData);
            }
        }

        private boolean unlockSession() {
            if (RepositoryBackedSession.this.lockedForUse.compareAndSet(true, false)) {
                return RepositoryBackedSession.this.concurrentUses.decrementAndGet() == 0;
            }
            return false;
        }

        private void invalidationOnCommit() {
            try {
                RepositoryBackedSession.this.wipeInvalidSession();
            }
            finally {
                RepositoryBackedSession.this.finishInvalidation(true);
            }
        }

        void storeToRepository(boolean commitAttributes, boolean keepChangedFlag) {
            SessionRepository.CommitTransaction transaction = RepositoryBackedSession.this.manager.getRepository().startCommit(RepositoryBackedSession.this.sessionData);
            logger.debug("Committing session: {}", (Object)RepositoryBackedSession.this.sessionData);
            if (commitAttributes) {
                this.commitAttributes(transaction, keepChangedFlag);
            }
            transaction.commit();
        }

        private void commitAttributes(SessionRepository.CommitTransaction transaction, boolean keepChangedFlag) {
            for (Map.Entry<String, Attribute> entry : RepositoryBackedSession.this.attrs.entrySet()) {
                Attribute attr;
                if (RepositoryBackedSession.this.sessionData.isNonCacheable(entry.getKey()) || !(attr = entry.getValue()).changed && !transaction.isSetAllAttributes()) continue;
                this.removeOrAddAttribute(transaction, entry.getKey(), attr);
                if (keepChangedFlag) continue;
                attr.changed = false;
            }
        }

        private void removeOrAddAttribute(SessionRepository.CommitTransaction transaction, String key, Attribute attr) {
            if (attr.deleted) {
                transaction.removeAttribute(key);
            } else {
                transaction.addAttribute(key, attr.value);
                if (transaction.isDistributing()) {
                    RepositoryBackedSession.this.manager.getNotifier().attributeBeingStored(RepositoryBackedSession.this, key, attr.value);
                }
            }
        }
    }

    private static class Attribute {
        private Object value;
        private boolean deleted;
        private boolean changed;

        public Attribute(Object value) {
            this.value = value;
        }
    }
}

