/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session;

import com.amadeus.session.shaded.org.slf4j.Logger;
import com.amadeus.session.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;

public class SessionConfiguration
implements Serializable {
    private static final long serialVersionUID = -4538053252686416412L;
    private static final Logger logger = LoggerFactory.getLogger(SessionConfiguration.class);
    public static final String DISTRIBUTABLE_SESSION = "com.amadeus.session.distributable";
    public static final String FORCE_DISTRIBUTABLE = "com.amadeus.session.distributable.force";
    public static final String DEFAULT_SESSION_TIMEOUT = "com.amadeus.session.timeout";
    public static final String NON_CACHEABLE_ATTRIBUTES = "com.amadeus.session.non-cacheable";
    public static final String SESSION_REPLICATION_TRIGGER = "com.amadeus.session.replication-trigger";
    public static final ReplicationTrigger DEFAULT_REPLICATION_TRIGGER = ReplicationTrigger.SET_AND_NON_PRIMITIVE_GET;
    public static final String LOG_MDC_SESSION_ENABLED = "com.amadeus.session.logging.mdc.enabled";
    public static final String LOG_MDC_SESSION_NAME = "com.amadeus.session.logging.mdc.name";
    public static final String LOGGING_MDC_DEFAULT_KEY = "JSESSIONID";
    public static final String STICKY_SESSIONS = "com.amadeus.session.sticky";
    public static final String DEFAULT_STICKY_SESSIONS = "true";
    public static final String SESSION_NAMESPACE = "com.amadeus.session.namespace";
    public static final String DEFAULT_SESSION_NAMESPACE = "default";
    public static final String SESSION_TIMESTAMP = "com.amadeus.session.timestamp";
    public static final String DEFAULT_SESSION_TIMESTAMP = "false";
    public static final int DEFAULT_SESSION_TIMEOUT_VALUE_NUM = 1800;
    private static final String DEFAULT_SESSION_TIMEOUT_VALUE = String.valueOf(1800);
    public static final String SESSION_HOST = "com.amadeus.session.host";
    public static final String PROVIDER_CONFIGURATION = "com.amadeus.session.repository.conf";
    public static final String REPOSITORY_FACTORY_NAME = "com.amadeus.session.repository.factory";
    public static final String SESSION_PROPAGATOR_NAME = "com.amadeus.session.tracking";
    public static final String SESSION_ID_NAME = "com.amadeus.session.sessionName";
    public static final String DEFAULT_SESSION_ID_NAME = "JSESSIONID";
    public static final String NODE_ID = "com.amadeus.session.node";
    public static final String DISABLED_SESSION = "com.amadeus.session.disabled";
    public static final String REUSE_CONCURRENT_SESSION = "com.amadeus.session.reuse.concurrent";
    public static final String SESSION_ID_PROVIDER = "com.amadeus.session.id";
    public static final String SESSION_ID_LENGTH = "com.amadeus.session.id.length";
    public static final String DEFAULT_SESSION_ID_LENGTH = "30";
    public static final String INTERCEPT_LISTENERS = "com.amadeus.session.intercept.listeners";
    public static final String COMMIT_ON_ALL_CONCURRENT = "com.amadeus.session.commit.concurrent";
    public static final String SESSION_ENCRYPTION_KEY = "com.amadeus.session.encryption.key";
    public static final String DELEGATE_WRITER = "com.amadeus.session.delegate.writer";
    private int maxInactiveInterval;
    private boolean distributable;
    private boolean sticky;
    private boolean timestampSufix;
    private boolean allowedCachedSessionReuse;
    private boolean interceptListeners;
    private boolean forceDistributable;
    private boolean loggingMdcActive;
    private boolean usingEncryption;
    private String loggingMdcKey;
    private String node;
    private String namespace;
    private String providerConfiguration;
    private String repositoryFactory;
    private String[] sessionTracking;
    private String sessionIdName;
    private String encryptionKey;
    private Set<String> nonCacheable;
    private ReplicationTrigger replicationTrigger;
    private Properties attributes = new Properties();
    private transient AttributeProvider currentAttributeProvider;
    private boolean commitOnAllConcurrent;
    private boolean delegateWriter;

    public SessionConfiguration() {
        this.distributable = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(DISTRIBUTABLE_SESSION, DEFAULT_STICKY_SESSIONS));
        this.sticky = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(STICKY_SESSIONS, DEFAULT_STICKY_SESSIONS));
        this.timestampSufix = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(SESSION_TIMESTAMP, DEFAULT_SESSION_TIMESTAMP));
        this.loggingMdcActive = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(LOG_MDC_SESSION_ENABLED, DEFAULT_STICKY_SESSIONS));
        this.loggingMdcKey = SessionConfiguration.getPropertySecured(LOG_MDC_SESSION_NAME, "JSESSIONID");
        this.namespace = SessionConfiguration.getPropertySecured(SESSION_NAMESPACE, null);
        this.sessionIdName = SessionConfiguration.getPropertySecured(SESSION_ID_NAME, "JSESSIONID");
        this.providerConfiguration = SessionConfiguration.getPropertySecured(PROVIDER_CONFIGURATION, null);
        this.repositoryFactory = SessionConfiguration.getPropertySecured(REPOSITORY_FACTORY_NAME, null);
        this.sessionTracking = this.parsePropagators(SessionConfiguration.getPropertySecured(SESSION_PROPAGATOR_NAME, null), null);
        this.allowedCachedSessionReuse = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(REUSE_CONCURRENT_SESSION, null));
        this.interceptListeners = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(INTERCEPT_LISTENERS, null));
        this.forceDistributable = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(FORCE_DISTRIBUTABLE, null));
        this.commitOnAllConcurrent = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(COMMIT_ON_ALL_CONCURRENT, null));
        this.delegateWriter = Boolean.parseBoolean(SessionConfiguration.getPropertySecured(DELEGATE_WRITER, null));
        this.setNonCacheable(SessionConfiguration.getPropertySecured(NON_CACHEABLE_ATTRIBUTES, null));
        String replicationValue = SessionConfiguration.getPropertySecured(SESSION_REPLICATION_TRIGGER, DEFAULT_REPLICATION_TRIGGER.toString());
        this.replicationTrigger = ReplicationTrigger.validate(replicationValue);
        this.maxInactiveInterval = 1800;
        String inactiveValue = SessionConfiguration.getPropertySecured(DEFAULT_SESSION_TIMEOUT, DEFAULT_SESSION_TIMEOUT_VALUE);
        try {
            if (this.nonEmpty(inactiveValue)) {
                this.maxInactiveInterval = Integer.parseInt(inactiveValue);
            }
        }
        catch (NumberFormatException e) {
            logger.error("`{}` system property was not an integer: {}, using default {}", DEFAULT_SESSION_TIMEOUT, inactiveValue, this.maxInactiveInterval);
        }
        this.node = SessionConfiguration.initNode();
        this.setEncryptionKey(SessionConfiguration.getPropertySecured(SESSION_ENCRYPTION_KEY, null));
    }

    private String[] parsePropagators(String value, String[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.split(",");
    }

    public void setEncryptionKey(String key) {
        this.encryptionKey = key;
        this.usingEncryption = key != null;
    }

    static boolean allowedProtocol(String protocol) {
        return "http".equals(protocol) || "https".equals(protocol) || "file".equals(protocol);
    }

    public void initializeFrom(AttributeProvider provider) {
        this.currentAttributeProvider = provider;
        this.distributable = this.read(DISTRIBUTABLE_SESSION, this.distributable);
        this.sticky = this.read(STICKY_SESSIONS, this.sticky);
        this.timestampSufix = this.read(SESSION_TIMESTAMP, this.timestampSufix);
        this.interceptListeners = this.read(INTERCEPT_LISTENERS, this.interceptListeners);
        this.allowedCachedSessionReuse = this.read(REUSE_CONCURRENT_SESSION, this.allowedCachedSessionReuse);
        this.sessionTracking = this.parsePropagators(this.read(SESSION_PROPAGATOR_NAME, null), this.sessionTracking);
        this.sessionIdName = this.read(SESSION_ID_NAME, this.sessionIdName);
        this.repositoryFactory = this.read(REPOSITORY_FACTORY_NAME, this.repositoryFactory);
        this.providerConfiguration = this.read(PROVIDER_CONFIGURATION, this.providerConfiguration);
        this.namespace = this.read(SESSION_NAMESPACE, this.namespace);
        this.node = this.read(SESSION_HOST, this.node);
        this.loggingMdcActive = this.read(LOG_MDC_SESSION_ENABLED, this.loggingMdcActive);
        this.loggingMdcKey = this.read(LOG_MDC_SESSION_NAME, this.loggingMdcKey);
        this.forceDistributable = this.read(FORCE_DISTRIBUTABLE, this.forceDistributable);
        this.setEncryptionKey(provider.getAttribute(SESSION_ENCRYPTION_KEY));
        String value = provider.getAttribute(SESSION_ENCRYPTION_KEY);
        if (this.nonEmpty(value)) {
            this.setEncryptionKey(value);
        }
        if (this.nonEmpty(value = provider.getAttribute(SESSION_REPLICATION_TRIGGER))) {
            this.replicationTrigger = ReplicationTrigger.validate(value);
        }
        if (this.nonEmpty(value = provider.getAttribute(NON_CACHEABLE_ATTRIBUTES))) {
            this.setNonCacheable(value);
        }
        this.initMaxInactiveInterval(provider);
    }

    private void initMaxInactiveInterval(AttributeProvider provider) {
        String val = provider.getAttribute(DEFAULT_SESSION_TIMEOUT);
        if (this.nonEmpty(val)) {
            try {
                this.maxInactiveInterval = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                logger.warn("`{}` configuration attribute was not an integer: {} for source {}", DEFAULT_SESSION_TIMEOUT, val, provider.source());
            }
        }
    }

    private boolean read(String key, boolean defaultValue) {
        String value = this.currentAttributeProvider.getAttribute(key);
        if (this.nonEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private String read(String key, String defaultValue) {
        String value = this.currentAttributeProvider.getAttribute(key);
        if (this.nonEmpty(value)) {
            return value;
        }
        return defaultValue;
    }

    private boolean nonEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public Set<String> getNonCacheable() {
        return this.nonCacheable;
    }

    public void setNonCacheable(Set<String> nonCacheable) {
        this.nonCacheable = Collections.unmodifiableSet(new HashSet<String>(nonCacheable));
    }

    public void setNonCacheable(String nonCacheableAttributesCsv) {
        if (nonCacheableAttributesCsv != null) {
            String[] attrs = nonCacheableAttributesCsv.split(",");
            this.nonCacheable = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(attrs)));
        }
    }

    public ReplicationTrigger getReplicationTrigger() {
        return this.replicationTrigger;
    }

    public void setReplicationTrigger(ReplicationTrigger replicationTrigger) {
        this.replicationTrigger = replicationTrigger;
    }

    public boolean isLoggingMdcActive() {
        return this.loggingMdcActive;
    }

    public void setLoggingMdcActive(boolean loggingMdcActive) {
        this.loggingMdcActive = loggingMdcActive;
    }

    public String getLoggingMdcKey() {
        return this.loggingMdcKey != null ? this.loggingMdcKey : "JSESSIONID";
    }

    public void setLoggingMdcKey(String loggingMdcKey) {
        this.loggingMdcKey = loggingMdcKey;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public boolean isTimestampSufix() {
        return this.timestampSufix;
    }

    public void setTimestampSufix(boolean timestamp) {
        this.timestampSufix = timestamp;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getNamespace() {
        return this.namespace == null ? DEFAULT_SESSION_NAMESPACE : this.namespace;
    }

    public String getTrueNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getProviderConfiguration() {
        return this.providerConfiguration;
    }

    public void setProviderConfiguration(String providerConfiguration) {
        this.providerConfiguration = providerConfiguration;
    }

    public String getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(String repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public String[] getSessionTracking() {
        return this.sessionTracking;
    }

    public void setSessionTracking(String ... sessionTracking) {
        this.sessionTracking = sessionTracking;
    }

    public String getSessionIdName() {
        return this.sessionIdName;
    }

    public void setSessionIdName(String sessionIdName) {
        this.sessionIdName = sessionIdName;
    }

    public boolean isAllowedCachedSessionReuse() {
        return this.allowedCachedSessionReuse;
    }

    public void setAllowedCachedSessionReuse(boolean allowedCachedSessionReuse) {
        this.allowedCachedSessionReuse = allowedCachedSessionReuse;
    }

    static String initNode() {
        String node = SessionConfiguration.getPropertySecured(NODE_ID, null);
        if (node != null) {
            return node;
        }
        try {
            if (SessionConfiguration.getPropertySecured("os.name", null).startsWith("Windows")) {
                node = System.getenv("COMPUTERNAME");
            } else {
                String hostname = System.getenv("HOSTNAME");
                if (hostname != null) {
                    node = hostname;
                }
            }
        }
        catch (SecurityException e) {
            logger.info("Security exception when trying to get environmnet variable", e);
        }
        if (node == null) {
            try {
                node = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.info("Unable to resolve local host, that's a strange error, but somehow it occured.", e);
                node = "unknown";
            }
        }
        return node;
    }

    public static String getPropertySecured(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (SecurityException e) {
            logger.info("Security exception when trying to get system property", e);
            return def;
        }
    }

    public String getAttribute(String key, String defaultValue) {
        String value = this.attributes.getProperty(key);
        if (value == null) {
            if (this.currentAttributeProvider != null) {
                value = this.currentAttributeProvider.getAttribute(key);
            }
            if (value == null) {
                value = SessionConfiguration.getPropertySecured(key, defaultValue);
            }
        }
        return value;
    }

    public void setAttribute(String key, String value) {
        this.attributes.setProperty(key, value);
    }

    public boolean isInterceptListeners() {
        return this.interceptListeners;
    }

    public void setInterceptListeners(boolean interceptListeners) {
        this.interceptListeners = interceptListeners;
    }

    public boolean isForceDistributable() {
        return this.forceDistributable;
    }

    public void setForceDistributable(boolean forceDistributable) {
        this.forceDistributable = forceDistributable;
    }

    public boolean isCommitOnAllConcurrent() {
        return this.commitOnAllConcurrent;
    }

    public void setCommitOnAllConcurrent(boolean commitOnAllConcurrent) {
        this.commitOnAllConcurrent = commitOnAllConcurrent;
    }

    public boolean isUsingEncryption() {
        return this.usingEncryption;
    }

    public void setUsingEncryption(boolean usingEncryption) {
        this.usingEncryption = usingEncryption;
    }

    public String getEncryptionKey() {
        if (!this.usingEncryption) {
            return null;
        }
        try {
            URL url = new URL(this.encryptionKey);
            if (SessionConfiguration.allowedProtocol(url.getProtocol())) {
                return this.loadKeyFromUrl(url);
            }
            throw new IllegalStateException("Unknown protocol in url `" + url + "`. Supported protocols are file, http and https. ");
        }
        catch (MalformedURLException e) {
            logger.info("Key was not provided via url.");
            return this.encryptionKey;
        }
    }

    public boolean isDelegateWriter() {
        return this.delegateWriter;
    }

    public void setDelegateWriter(boolean delegateWriter) {
        this.delegateWriter = delegateWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadKeyFromUrl(URL url) {
        try (InputStream is = url.openStream();){
            Throwable throwable;
            Scanner s;
            block25: {
                String string;
                block26: {
                    s = new Scanner(is);
                    throwable = null;
                    s.useDelimiter("\\A");
                    if (!s.hasNext()) break block25;
                    this.encryptionKey = s.next();
                    logger.info("Loaded ecnryption key from url `{}`", (Object)url);
                    string = this.encryptionKey;
                    if (s == null) return string;
                    if (throwable == null) break block26;
                    try {
                        s.close();
                        return string;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return string;
                    }
                }
                s.close();
                return string;
            }
            try {
                try {
                    throw new IllegalStateException("Unable to load key from url `" + url + "`. Destination was empty.");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (s == null) throw throwable4;
                if (throwable == null) {
                    s.close();
                    throw throwable4;
                }
                try {
                    s.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load key from url `" + url + "`.", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SessionConfiguration [namespace=").append(this.namespace).append(", node=").append(this.node).append(", sessionIdName=").append(this.sessionIdName).append(", maxInactiveInterval=").append(this.maxInactiveInterval).append(", distributable=").append(this.distributable).append(", sticky=").append(this.sticky).append(", allowedCachedSessionReuse=").append(this.allowedCachedSessionReuse).append(", interceptListeners=").append(this.interceptListeners).append(", forceDistributable=").append(this.forceDistributable).append(", loggingMdcActive=").append(this.loggingMdcActive).append(", usingEncryption=").append(this.usingEncryption).append(", loggingMdcKey=").append(this.loggingMdcKey).append(", providerConfiguration=").append(this.providerConfiguration).append(", repositoryFactory=").append(this.repositoryFactory).append(", sessionTracking=").append(this.sessionTracking).append(", encryptionKey=").append(this.encryptionKey).append(", nonCacheable=").append(this.nonCacheable).append(", replicationTrigger=").append((Object)this.replicationTrigger).append(", attributes=").append(this.attributes).append(", commitOnAllConcurrent=").append(this.commitOnAllConcurrent).append(", timestamp=").append(this.timestampSufix).append("]");
        return builder.toString();
    }

    public static interface AttributeProvider {
        public String getAttribute(String var1);

        public Object source();
    }

    public static enum ReplicationTrigger {
        SET_AND_NON_PRIMITIVE_GET(true),
        SET(false);

        private final boolean replicateOnGet;

        private ReplicationTrigger(boolean replicateOnTrigger) {
            this.replicateOnGet = replicateOnTrigger;
        }

        public boolean isReplicateOnGet() {
            return this.replicateOnGet;
        }

        public static ReplicationTrigger validate(String replicationValue) {
            try {
                return ReplicationTrigger.valueOf(replicationValue);
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid configuration '{}': Replication trigger value was not one of [{}]. The value was {}. Using default value {}", new Object[]{SessionConfiguration.SESSION_REPLICATION_TRIGGER, Arrays.asList(ReplicationTrigger.values()), replicationValue, SET_AND_NON_PRIMITIVE_GET});
                return DEFAULT_REPLICATION_TRIGGER;
            }
        }
    }
}

