/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session;

import java.util.Set;
import java.util.concurrent.TimeUnit;

public class SessionData {
    private String id;
    private String oldSessionId;
    private long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private Set<String> repositoryKeys;
    private Set<String> mandatoryRemoteKeys;
    private boolean isNew;
    private final long originalLastAccessed;
    private final String previousOwner;

    public SessionData(String id, long lastAccessedTime, int maxInactiveInterval, long creationTime, String previousOwner) {
        this.id = id;
        this.originalLastAccessed = lastAccessedTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.lastAccessedTime = lastAccessedTime;
        this.creationTime = creationTime;
        this.previousOwner = previousOwner;
    }

    public SessionData(String sessionId, long creationTime, int maxInactiveInterval) {
        this(sessionId, creationTime, maxInactiveInterval, creationTime, null);
        this.isNew = true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isMaybeInRepository(String name) {
        return this.repositoryKeys == null || this.repositoryKeys.contains(name);
    }

    public Set<String> getRepositoryKeys() {
        return this.repositoryKeys;
    }

    void setRepositoryKeys(Set<String> repositoryKeys) {
        this.repositoryKeys = repositoryKeys;
    }

    public Set<String> getMandatoryRemoteKeys() {
        return this.mandatoryRemoteKeys;
    }

    public void setMandatoryRemoteKeys(Set<String> mandatoryRemoteKeys) {
        this.mandatoryRemoteKeys = mandatoryRemoteKeys;
    }

    public long getOriginalLastAccessed() {
        return this.originalLastAccessed;
    }

    public String getPreviousOwner() {
        return this.previousOwner;
    }

    public long expiresAt() {
        return this.lastAccessedTime + TimeUnit.SECONDS.toMillis(this.maxInactiveInterval);
    }

    public boolean isNonCacheable(String key) {
        return this.mandatoryRemoteKeys != null && this.mandatoryRemoteKeys.contains(key);
    }

    public String getOldSessionId() {
        return this.oldSessionId;
    }

    public void setNewSessionId(String newSessionId) {
        this.oldSessionId = this.id;
        this.id = newSessionId;
    }

    public String getOriginalId() {
        return this.oldSessionId != null ? this.oldSessionId : this.id;
    }

    public boolean isIdChanged() {
        return this.oldSessionId != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (int)(this.originalLastAccessed ^ this.originalLastAccessed >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionData other = (SessionData)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.originalLastAccessed == other.originalLastAccessed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SessionData [id=").append(this.id).append(", oldSessionId=").append(this.oldSessionId).append(", creationTime=").append(this.creationTime).append(", lastAccessedTime=").append(this.lastAccessedTime).append(", maxInactiveInterval=").append(this.maxInactiveInterval).append(", isNew=").append(this.isNew).append(", previousOwner=").append(this.previousOwner).append("]");
        return builder.toString();
    }
}

