/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.SessionManager;
import com.amadeus.session.repository.redis.RedisFacade;
import com.amadeus.session.repository.redis.RedisSessionRepository;
import com.amadeus.session.repository.redis.SafeEncoder;
import com.amadeus.session.shaded.org.slf4j.Logger;
import com.amadeus.session.shaded.org.slf4j.LoggerFactory;

class ExpirationListener
implements RedisFacade.RedisPubSub {
    private static Logger logger = LoggerFactory.getLogger(ExpirationListener.class);
    private static final String SUBSCRIPTION_PATTERN = "__keyevent@*__:expired";
    private final SessionManager sessionManager;
    private static final byte[] EXPIRED_SUFFIX = SafeEncoder.encode(":expired");
    private final byte[] keyPrefix;
    private boolean subsrcibed;
    private Object linkedImplementation;

    ExpirationListener(SessionManager sessionManager, String keyPrefix) {
        this.sessionManager = sessionManager;
        this.keyPrefix = SafeEncoder.encode(keyPrefix);
    }

    @Override
    public void onPMessage(byte[] pattern, byte[] channelBuf, byte[] message) {
        if (channelBuf == null || message == null) {
            return;
        }
        if (!this.isExpiredChannel(channelBuf)) {
            return;
        }
        if (!this.isExpireKey(message)) {
            return;
        }
        String body = SafeEncoder.encode(message);
        if (logger.isDebugEnabled()) {
            logger.debug("Got notification for channel: '{}', body: '{}'", (Object)SafeEncoder.encode(channelBuf), (Object)body);
        }
        String sessionId = RedisSessionRepository.extractSessionId(body);
        logger.info("Session expired event for sessionId: '{}'", (Object)sessionId);
        this.sessionManager.deleteAsync(sessionId, true);
    }

    private boolean isExpiredChannel(byte[] channelBuf) {
        int suffixLength = EXPIRED_SUFFIX.length;
        int channelPos = channelBuf.length - suffixLength;
        if (channelPos <= 0) {
            return false;
        }
        int i = 0;
        while (i < suffixLength) {
            if (channelBuf[channelPos] != EXPIRED_SUFFIX[i]) {
                return false;
            }
            ++i;
            ++channelPos;
        }
        return true;
    }

    private boolean isExpireKey(byte[] message) {
        int prefixLength = this.keyPrefix.length;
        if (message.length < prefixLength) {
            return false;
        }
        for (int i = 0; i < prefixLength; ++i) {
            if (message[i] == this.keyPrefix[i]) continue;
            return false;
        }
        return true;
    }

    void start(RedisFacade redis) {
        this.subsrcibed = true;
        redis.psubscribe(this, SUBSCRIPTION_PATTERN);
    }

    void close(RedisFacade redis) {
        if (this.subsrcibed) {
            redis.punsubscribe(this, SafeEncoder.encode(SUBSCRIPTION_PATTERN));
            this.subsrcibed = false;
        }
    }

    @Override
    public Object getLinked() {
        return this.linkedImplementation;
    }

    @Override
    public void link(Object linkedImplementation) {
        this.linkedImplementation = linkedImplementation;
    }
}

