/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.repository.redis.AbstractJedisFacade;
import com.amadeus.session.repository.redis.RedisFacade;
import com.amadeus.session.repository.redis.SafeEncoder;
import com.amadeus.session.shaded.com.codahale.metrics.MetricRegistry;
import com.amadeus.session.shaded.redis.clients.jedis.BinaryJedisPubSub;
import com.amadeus.session.shaded.redis.clients.jedis.Jedis;
import com.amadeus.session.shaded.redis.clients.jedis.Transaction;
import com.amadeus.session.shaded.redis.clients.util.Pool;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JedisPoolFacade
extends AbstractJedisFacade {
    private final Pool<Jedis> jedisPool;
    private final ThreadLocal<Jedis> currentJedis = new ThreadLocal();

    JedisPoolFacade(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    Jedis jedis() {
        Jedis jedis = this.currentJedis.get();
        if (jedis == null) {
            jedis = this.jedisPool.getResource();
            this.currentJedis.set(jedis);
        }
        return jedis;
    }

    @Override
    public void requestFinished() {
        Jedis jedis = this.currentJedis.get();
        if (jedis != null) {
            this.currentJedis.set(null);
            jedis.close();
        }
    }

    @Override
    public void psubscribe(final RedisFacade.RedisPubSub listener, String pattern) {
        BinaryJedisPubSub bps = new BinaryJedisPubSub(){

            @Override
            public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
                listener.onPMessage(pattern, channel, message);
            }
        };
        listener.link(bps);
        this.jedis().psubscribe(bps, new byte[][]{SafeEncoder.encode(pattern)});
    }

    @Override
    public void punsubscribe(RedisFacade.RedisPubSub listener, byte[] pattern) {
        ((BinaryJedisPubSub)listener.getLinked()).punsubscribe(new byte[][]{pattern});
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        return this.jedis().hdel(key, fields);
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        return this.jedis().hmget(key, fields);
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        return this.jedis().hmset(key, hash);
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        return this.jedis().hsetnx(key, field, value);
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        return this.jedis().hset(key, field, value);
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        return this.jedis().hkeys(key);
    }

    @Override
    public String set(byte[] key, byte[] value) {
        return this.jedis().set(key, value);
    }

    @Override
    public String setex(byte[] key, int expiry, byte[] value) {
        return this.jedis().setex(key, expiry, value);
    }

    @Override
    public Long expire(byte[] key, int value) {
        return this.jedis().expire(key, value);
    }

    @Override
    public void srem(byte[] key, byte[] ... member) {
        this.jedis().srem(key, member);
    }

    @Override
    public Long sadd(byte[] key, byte[] ... member) {
        return this.jedis().sadd(key, member);
    }

    @Override
    public Long del(byte[] ... keys) {
        return this.jedis().del(keys);
    }

    @Override
    public Boolean exists(byte[] key) {
        return this.jedis().exists(key);
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        return this.jedis().smembers(key);
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count) {
        return this.jedis().spop(key, count);
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        return this.jedis().expireAt(key, unixTime);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] elem) {
        return this.jedis().zadd(key, score, elem);
    }

    @Override
    public Long zrem(byte[] key, byte[] ... fields) {
        return this.jedis().zrem(key, fields);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double start, double end) {
        return this.jedis().zrangeByScore(key, start, end);
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start, long end) {
        return this.jedis().zrange(key, start, end);
    }

    @Override
    public Long persist(byte[] key) {
        return this.jedis().persist(key);
    }

    @Override
    public String info(String section) {
        return this.jedis().info(section);
    }

    @Override
    public <T> RedisFacade.ResponseFacade<T> transaction(byte[] key, RedisFacade.TransactionRunner<T> transaction) {
        Transaction t = this.jedis().multi();
        RedisFacade.ResponseFacade<T> response = transaction.run(JedisPoolFacade.wrapJedisTransaction(t));
        t.exec();
        return response;
    }

    @Override
    public void close() {
        this.jedisPool.close();
    }

    @Override
    public String rename(byte[] oldkey, byte[] newkey) {
        return this.jedis().rename(oldkey, newkey);
    }

    @Override
    public byte[] get(byte[] key) {
        return this.jedis().get(key);
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        return this.jedis().publish(channel, message);
    }

    @Override
    public void startMonitoring(MetricRegistry metrics) {
        AbstractJedisFacade.addMetrics(this.jedisPool, metrics);
    }
}

