/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.repository.redis.AbstractJedisFacade;
import com.amadeus.session.repository.redis.RedisFacade;
import com.amadeus.session.shaded.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import com.amadeus.session.shaded.redis.clients.jedis.HostAndPort;
import com.amadeus.session.shaded.redis.clients.jedis.Jedis;
import com.amadeus.session.shaded.redis.clients.jedis.JedisCluster;
import com.amadeus.session.shaded.redis.clients.jedis.JedisClusterCommand;
import com.amadeus.session.shaded.redis.clients.jedis.JedisPoolConfig;
import com.amadeus.session.shaded.redis.clients.jedis.Transaction;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

class TransactionalJedisCluster
extends JedisCluster {
    TransactionalJedisCluster(Set<HostAndPort> hostAndPort, int timeout, JedisPoolConfig config) {
        super(hostAndPort, timeout, (GenericObjectPoolConfig)config);
    }

    public <T> RedisFacade.ResponseFacade<T> transaction(RedisFacade.TransactionRunner<T> transaction) {
        TransactionAsSequence t = new TransactionAsSequence(this);
        RedisFacade.ResponseFacade<T> response = transaction.run(t);
        t.exec();
        return response;
    }

    public <T> RedisFacade.ResponseFacade<T> transaction(byte[] key, final RedisFacade.TransactionRunner<T> transaction) {
        return (RedisFacade.ResponseFacade)new JedisClusterCommand<RedisFacade.ResponseFacade<T>>(this.connectionHandler, this.maxAttempts){

            @Override
            public RedisFacade.ResponseFacade<T> execute(Jedis connection) {
                Transaction t = connection.multi();
                RedisFacade.ResponseFacade response = transaction.run(AbstractJedisFacade.wrapJedisTransaction(t));
                t.exec();
                return response;
            }
        }.runBinary(key);
    }

    @Override
    public String info(final String section) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            @Override
            public String execute(Jedis connection) {
                return connection.info(section);
            }
        }.runWithAnyNode();
    }

    static class TransactionAsSequence
    implements RedisFacade.TransactionFacade {
        private final JedisCluster jedis;
        private final ArrayList<Runnable> operations = new ArrayList();
        private Set<byte[]> smembersResult;

        TransactionAsSequence(JedisCluster jedis) {
            this.jedis = jedis;
        }

        @Override
        public void hdel(final byte[] key, final byte[] ... fields) {
            this.operations.add(new Runnable(){

                @Override
                public void run() {
                    TransactionAsSequence.this.jedis.hdel(key, fields);
                }
            });
        }

        @Override
        public void hmset(final byte[] key, final Map<byte[], byte[]> hash) {
            this.operations.add(new Runnable(){

                @Override
                public void run() {
                    TransactionAsSequence.this.jedis.hmset(key, hash);
                }
            });
        }

        @Override
        public void del(final byte[] ... keys) {
            this.operations.add(new Runnable(){

                @Override
                public void run() {
                    TransactionAsSequence.this.jedis.del(keys);
                }
            });
        }

        @Override
        public RedisFacade.ResponseFacade<Set<byte[]>> smembers(final byte[] key) {
            this.operations.add(new Runnable(){

                @Override
                public void run() {
                    TransactionAsSequence.this.smembersResult = TransactionAsSequence.this.jedis.smembers(key);
                }
            });
            return new RedisFacade.ResponseFacade<Set<byte[]>>(){

                @Override
                public Set<byte[]> get() {
                    return TransactionAsSequence.this.smembersResult;
                }
            };
        }

        public void exec() {
            for (Runnable r : this.operations) {
                r.run();
            }
        }
    }
}

