/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.RandomIdProvider;
import com.amadeus.session.RequestWithSession;
import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.SessionIdProvider;
import com.amadeus.session.SessionTracking;
import com.amadeus.session.UuidProvider;

public abstract class BaseSessionTracking
implements SessionTracking {
    protected String idName;
    protected SessionIdProvider idProvider;
    private boolean appendTimestamp;
    protected static final char SESSION_ID_TIMESTAMP_SEPARATOR = '!';
    protected SessionTracking nextSessionTracking;

    @Override
    public void configure(SessionConfiguration configuration) {
        this.idName = configuration.getSessionIdName();
        String idProviderType = configuration.getAttribute("com.amadeus.session.id", "random");
        this.appendTimestamp = configuration.isTimestampSufix();
        this.idProvider = "uuid".equals(idProviderType) ? new UuidProvider() : new RandomIdProvider();
        this.idProvider.configure(configuration);
    }

    @Override
    public String newId() {
        String newId = this.idProvider.newId();
        if (this.appendTimestamp) {
            StringBuilder suffixedId = new StringBuilder(newId.length() + 11).append(newId);
            newId = suffixedId.append('!').append(System.currentTimeMillis()).toString();
        }
        return newId;
    }

    @Override
    public String encodeUrl(RequestWithSession request, String url) {
        return url;
    }

    protected String clean(String value) {
        if (!this.appendTimestamp) {
            return this.idProvider.readId(value);
        }
        String timeStamp = "";
        String cleanValue = value;
        int separatorIndex = value.lastIndexOf(33);
        if (separatorIndex != -1) {
            timeStamp = value.substring(separatorIndex);
            cleanValue = value.substring(0, separatorIndex);
        }
        return (cleanValue = this.idProvider.readId(cleanValue)) != null ? cleanValue + timeStamp : cleanValue;
    }

    @Override
    public void nextSessionTracking(SessionTracking next) {
        this.nextSessionTracking = next;
    }
}

