/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.RepositoryBackedSession;
import com.amadeus.session.RequestWithSession;
import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.SessionTracking;
import com.amadeus.session.servlet.BaseSessionTracking;
import com.amadeus.session.servlet.ServletLevel;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class CookieSessionTracking
extends BaseSessionTracking
implements SessionTracking {
    static final String DEFAULT_CONTEXT_PATH = "/";
    static final String COOKIE_CONTEXT_PATH_PARAMETER = "com.amadeus.session.cookie.contextPath";
    static final String SECURE_COOKIE_PARAMETER = "com.amadeus.session.cookie.secure";
    static final String SECURE_COOKIE_ON_SECURED_REQUEST_PARAMETER = "com.amadeus.session.cookie.secure.on.secured.request";
    static final String COOKIE_HTTP_ONLY_PARAMETER = "com.amadeus.session.cookie.httpOnly";
    private boolean httpOnly = true;
    private String contextPath;
    private Boolean secure;
    private Boolean secureOnlyOnSecuredRequest;

    CookieSessionTracking() {
    }

    @Override
    public SessionTracking.IdAndSource retrieveId(RequestWithSession request) {
        Cookie[] cookies = ((HttpServletRequest)request).getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.idName.equals(cookie.getName())) continue;
                String id = this.clean(cookie.getValue());
                if (id != null) {
                    return new SessionTracking.IdAndSource(id, this.isCookieTracking());
                }
                return null;
            }
        }
        if (this.nextSessionTracking != null) {
            return this.nextSessionTracking.retrieveId(request);
        }
        return null;
    }

    @Override
    public void propagateSession(RequestWithSession request, Object response) {
        Cookie cookie = new Cookie(this.idName, "");
        RepositoryBackedSession session = request.getRepositoryBackedSession(false);
        if (session != null && !session.isValid()) {
            session = null;
        }
        if (session == null) {
            cookie.setMaxAge(0);
        } else {
            cookie.setValue(session.getId());
        }
        if (ServletLevel.isServlet3) {
            cookie.setHttpOnly(this.httpOnly);
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.secure.booleanValue()) {
            cookie.setSecure(this.secureOnlyOnSecuredRequest != false ? httpRequest.isSecure() : true);
        }
        cookie.setPath(this.cookiePath());
        ((HttpServletResponse)response).addCookie(cookie);
    }

    private String cookiePath() {
        if (this.contextPath != null) {
            return this.contextPath;
        }
        return DEFAULT_CONTEXT_PATH;
    }

    @Override
    public void configure(SessionConfiguration conf) {
        super.configure(conf);
        this.httpOnly = Boolean.valueOf(conf.getAttribute(COOKIE_HTTP_ONLY_PARAMETER, "true"));
        this.secure = Boolean.valueOf(conf.getAttribute(SECURE_COOKIE_PARAMETER, "false"));
        this.secureOnlyOnSecuredRequest = Boolean.valueOf(conf.getAttribute(SECURE_COOKIE_ON_SECURED_REQUEST_PARAMETER, "false"));
        this.contextPath = conf.getAttribute(COOKIE_CONTEXT_PATH_PARAMETER, null);
    }

    @Override
    public boolean isCookieTracking() {
        return true;
    }
}

