/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.RequestWithSession;
import com.amadeus.session.SessionManager;
import com.amadeus.session.SessionTracking;
import com.amadeus.session.servlet.Attributes;
import com.amadeus.session.servlet.HttpResponseWrapper;
import com.amadeus.session.servlet.RepositoryBackedHttpSession;
import com.amadeus.session.shaded.org.slf4j.Logger;
import com.amadeus.session.shaded.org.slf4j.LoggerFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class HttpRequestWrapper
extends HttpServletRequestWrapper
implements RequestWithSession {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestWrapper.class);
    RepositoryBackedHttpSession session;
    boolean committed;
    private HttpResponseWrapper response;
    private final HttpRequestWrapper embeddedRequest;
    private final SessionManager manager;
    private final ServletContext servletContext;
    private boolean propagateOnCreate;
    private boolean propagated;
    private boolean idRetrieved;
    private String retrievedId;
    private boolean isRetrievedIdFromCookie;
    private boolean repositoryChecked;

    public HttpRequestWrapper(HttpServletRequest req, ServletContext servletContext) {
        super(req);
        this.servletContext = servletContext;
        this.manager = (SessionManager)servletContext.getAttribute(Attributes.SESSION_MANAGER);
        HttpServletRequest originalRequest = req;
        while (originalRequest instanceof ServletRequestWrapper && !(originalRequest instanceof HttpRequestWrapper)) {
            originalRequest = ((ServletRequestWrapper)originalRequest).getRequest();
        }
        this.embeddedRequest = originalRequest instanceof HttpRequestWrapper ? (HttpRequestWrapper)originalRequest : null;
    }

    public RepositoryBackedHttpSession getSession() {
        return this.getSession(true);
    }

    public RepositoryBackedHttpSession getSession(boolean create) {
        if (this.embeddedRequest != null) {
            this.embeddedRequest.getSession(create);
        }
        return this.getRepositoryBackedSession(create);
    }

    public SessionManager getManager() {
        return this.manager;
    }

    public HttpResponseWrapper getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponseWrapper response) {
        this.response = response;
    }

    boolean propagateSession() {
        if (this.committed && !this.isDirty()) {
            return true;
        }
        if (this.getRepositoryBackedSession(false) == null) {
            this.setPropagateOnCreate(true);
            return false;
        }
        return this.doPropagateAndStoreIfFirstWrapper();
    }

    private boolean doPropagateAndStoreIfFirstWrapper() {
        if (this.embeddedRequest == null && (!this.propagated || this.isDirty())) {
            this.manager.propagateSession(this, this.response);
            this.storeSession();
            this.propagated = true;
            return true;
        }
        return false;
    }

    private boolean isDirty() {
        return this.session != null && this.session.isDirty();
    }

    void retrieveSessionIfNeeded(boolean create) {
        if (this.embeddedRequest != null) {
            this.embeddedRequest.retrieveSessionIfNeeded(create);
        }
        if (this.session == null || !this.session.isValid()) {
            this.session = (RepositoryBackedHttpSession)this.manager.getSession(this, create, this.getEmbededdSessionId());
        }
    }

    private SessionTracking.IdAndSource getEmbededdSessionId() {
        if (this.embeddedRequest != null && this.embeddedRequest.session != null && this.embeddedRequest.session.isValid()) {
            return new SessionTracking.IdAndSource(this.embeddedRequest.session.getId(), this.embeddedRequest.isRetrievedIdFromCookie);
        }
        return null;
    }

    public void commit() {
        this.doCommit();
    }

    void doCommit() {
        if (this.committed) {
            return;
        }
        if (!this.propagateSession()) {
            this.storeSession();
        }
        this.committed = true;
        this.manager.requestFinished();
    }

    void storeSession() {
        this.retrieveSessionIfNeeded(false);
        if (this.session != null) {
            try {
                this.session.commit();
            }
            catch (Exception e) {
                logger.warn("cannot store session: {}", (Object)this.session, (Object)e);
            }
        } else {
            logger.debug("session was null, nothing to commit");
        }
    }

    @Override
    public RepositoryBackedHttpSession getRepositoryBackedSession(boolean create) {
        if (this.committed) {
            throw new IllegalStateException("Session was already committed.");
        }
        boolean wasNotCreated = this.session == null;
        this.retrieveSessionIfNeeded(create);
        if (wasNotCreated && this.propagateOnCreate) {
            this.doPropagateAndStoreIfFirstWrapper();
        }
        return this.session;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpRequestWrapper getEmbeddedRequest() {
        return this.embeddedRequest;
    }

    public boolean isPropagateOnCreate() {
        return this.propagateOnCreate;
    }

    public void setPropagateOnCreate(boolean propagate) {
        this.propagateOnCreate = propagate;
        if (this.embeddedRequest != null) {
            this.embeddedRequest.setPropagateOnCreate(true);
        }
    }

    @Override
    public boolean isIdRetrieved() {
        return this.idRetrieved;
    }

    @Override
    public void setRequestedSessionId(String id, boolean isFromCookie) {
        this.idRetrieved = true;
        this.retrievedId = id;
        this.isRetrievedIdFromCookie = isFromCookie;
    }

    @Override
    public String getRequestedSessionId() {
        this.retrieveSessionId();
        return this.retrievedId;
    }

    private void retrieveSessionId() {
        if (!this.idRetrieved) {
            this.getSession(false);
        }
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        this.retrieveSessionId();
        return this.retrievedId != null && this.isRetrievedIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        this.retrieveSessionId();
        return this.retrievedId != null && !this.isRetrievedIdFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        this.retrieveSessionId();
        return this.retrievedId != null && this.isRepositoryChecked();
    }

    @Override
    public boolean isRepositoryChecked() {
        return this.repositoryChecked;
    }

    @Override
    public void repositoryChecked() {
        this.repositoryChecked = true;
    }

    public String encodeURL(String url) {
        return this.manager.encodeUrl(this, url);
    }

    public String changeSessionId() {
        this.retrieveSessionIfNeeded(false);
        if (this.session == null) {
            throw new IllegalStateException("There is no session associated with the request.");
        }
        this.manager.switchSessionId(this.session);
        return this.session.getId();
    }
}

