/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.ResponseWithSessionId;
import com.amadeus.session.servlet.HttpRequestWrapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class HttpResponseWrapper
extends HttpServletResponseWrapper
implements ResponseWithSessionId {
    private static final int LN_LENGTH = System.getProperty("line.separator").length();
    private static final byte[] CRLF = new byte[]{13, 10};
    private final HttpRequestWrapper request;
    private PrintWriter writer;
    private long contentWritten;
    protected long contentLength;
    private SaveSessionServletOutputStream outputStream;
    private final boolean delegatePrintWriter;

    HttpResponseWrapper(HttpRequestWrapper request, HttpServletResponse response) {
        super(response);
        this.delegatePrintWriter = request.getManager().getConfiguration().isDelegateWriter();
        this.request = request;
    }

    public final void sendError(int sc) throws IOException {
        this.request.propagateSession();
        super.sendError(sc);
    }

    public final void sendError(int sc, String msg) throws IOException {
        this.request.propagateSession();
        super.sendError(sc, msg);
        this.closeOutput();
    }

    public final void sendRedirect(String location) throws IOException {
        this.request.propagateSession();
        super.sendRedirect(location);
        this.closeOutput();
    }

    public SaveSessionServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("Only one of getWriter()/getOutputStream() can be called, and writer is already used.");
        }
        if (this.outputStream == null) {
            this.outputStream = this.wrapOutputStream(super.getOutputStream());
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("Only one of getWriter()/getOutputStream() can be called, and output stream is already used.");
        }
        if (this.writer == null) {
            this.writer = this.wrapPrintWriter();
        }
        return this.writer;
    }

    protected SaveSessionServletOutputStream wrapOutputStream(ServletOutputStream servletOutputStream) {
        return new SaveSessionServletOutputStream(servletOutputStream);
    }

    private PrintWriter wrapPrintWriter() throws IOException {
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
            this.setCharacterEncoding(encoding);
        }
        if (this.delegatePrintWriter) {
            return new DelegateServletPrintWriter(super.getWriter());
        }
        SaveSessionServletOutputStream wrappedStream = this.wrapOutputStream(super.getOutputStream());
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)((Object)wrappedStream), encoding);
        SimplestServletPrintWriter myWriter = new SimplestServletPrintWriter(osw);
        wrappedStream.setAssociated(myWriter);
        return myWriter;
    }

    public void addHeader(String name, String value) {
        this.checkContentLenghtHeader(name, value);
        super.addHeader(name, value);
    }

    void checkContentLenghtHeader(String name, String value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this.contentLength = Long.parseLong(value);
        }
    }

    public void setHeader(String name, String value) {
        this.checkContentLenghtHeader(name, value);
        super.setHeader(name, value);
    }

    public void setContentLength(int len) {
        this.contentLength = len;
        super.setContentLength(len);
    }

    private void checkContentLength(int contentLengthToWrite) {
        boolean requiresFlush;
        this.contentWritten += (long)contentLengthToWrite;
        boolean isBodyFullyWritten = this.contentLength > 0L && this.contentWritten >= this.contentLength;
        int bufferSize = this.getBufferSize();
        boolean bl = requiresFlush = bufferSize > 0 && this.contentWritten >= (long)bufferSize;
        if (isBodyFullyWritten || requiresFlush) {
            try {
                this.flushAndPropagate();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public void reset() {
        super.reset();
        this.request.removeAttribute("com.amadeus.session.isPropagated");
    }

    public String encodeURL(String url) {
        return this.request.encodeURL(url);
    }

    public void flushBuffer() throws IOException {
        this.flushAndPropagate();
        super.flushBuffer();
    }

    private void flushAndPropagate() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        } else if (this.writer != null) {
            this.writer.flush();
        } else {
            this.request.propagateSession();
        }
    }

    private void closeOutput() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    class DelegateServletPrintWriter
    extends PrintWriter {
        private final PrintWriter delegate;

        DelegateServletPrintWriter(PrintWriter delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public void flush() {
            HttpResponseWrapper.this.request.propagateSession();
            this.delegate.flush();
        }

        @Override
        public void close() {
            HttpResponseWrapper.this.request.propagateSession();
            this.delegate.close();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }

        @Override
        public boolean checkError() {
            return this.delegate.checkError();
        }

        @Override
        public void write(int c) {
            String s = Character.toString((char)c);
            this.write(s);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            HttpResponseWrapper.this.checkContentLength(len);
            this.delegate.write(buf, off, len);
        }

        @Override
        public void write(char[] buf) {
            HttpResponseWrapper.this.checkContentLength(buf.length);
            this.delegate.write(buf);
        }

        @Override
        public void write(String s, int off, int len) {
            HttpResponseWrapper.this.checkContentLength(len);
            this.delegate.write(s, off, len);
        }

        @Override
        public void write(String s) {
            this.write(s, 0, s.length());
        }

        @Override
        public void print(boolean b) {
            this.write(Boolean.toString(b));
        }

        @Override
        public void print(char c) {
            this.write(Character.toString(c));
        }

        @Override
        public void print(int i) {
            this.write(Integer.toString(i));
        }

        @Override
        public void print(long l) {
            this.write(Long.toString(l));
        }

        @Override
        public void print(float f) {
            this.write(Float.toString(f));
        }

        @Override
        public void print(double d) {
            this.write(Double.toString(d));
        }

        @Override
        public void print(char[] s) {
            this.write(s);
        }

        @Override
        public void print(String s) {
            this.write(s == null ? "null" : s);
        }

        @Override
        public void print(Object obj) {
            this.write(obj == null ? "null" : obj.toString());
        }

        @Override
        public void println() {
            HttpResponseWrapper.this.checkContentLength(LN_LENGTH);
            super.println();
        }
    }

    static class SimplestServletPrintWriter
    extends PrintWriter {
        boolean closing;

        SimplestServletPrintWriter(Writer out) {
            super(out);
        }

        @Override
        public void close() {
            if (!this.closing) {
                this.closing = true;
                super.close();
            }
        }
    }

    class SaveSessionServletOutputStream
    extends ServletOutputStream {
        protected final ServletOutputStream delegate;
        private Closeable associated;
        boolean closing;

        SaveSessionServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        void setAssociated(Closeable associated) {
            this.associated = associated;
        }

        public void write(int b) throws IOException {
            HttpResponseWrapper.this.checkContentLength(1);
            this.delegate.write(b);
        }

        public void flush() throws IOException {
            HttpResponseWrapper.this.request.propagateSession();
            this.delegate.flush();
        }

        public void close() throws IOException {
            if (this.closing) {
                return;
            }
            this.closing = true;
            if (this.associated != null) {
                this.associated.close();
            }
            HttpResponseWrapper.this.request.propagateSession();
            this.delegate.flush();
            this.delegate.close();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public void print(char c) throws IOException {
            this.print(String.valueOf(c));
        }

        public void print(int i) throws IOException {
            this.print(String.valueOf(i));
        }

        public void print(long l) throws IOException {
            this.print(String.valueOf(l));
        }

        public void print(float f) throws IOException {
            this.print(String.valueOf(f));
        }

        public void print(double d) throws IOException {
            this.print(String.valueOf(d));
        }

        public void println() throws IOException {
            this.write(CRLF);
        }

        public void println(String s) throws IOException {
            this.print(s);
            this.println();
        }

        public void println(boolean b) throws IOException {
            this.print(b);
            this.println();
        }

        public void println(char c) throws IOException {
            this.print(c);
            this.println();
        }

        public void println(int i) throws IOException {
            this.print(i);
            this.println();
        }

        public void println(long l) throws IOException {
            this.print(l);
            this.println();
        }

        public void println(float f) throws IOException {
            this.print(f);
            this.println();
        }

        public void write(byte[] b) throws IOException {
            HttpResponseWrapper.this.checkContentLength(b.length);
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            HttpResponseWrapper.this.checkContentLength(len);
            this.delegate.write(b, off, len);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

