/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.RepositoryBackedSession;
import com.amadeus.session.SessionNotifier;
import com.amadeus.session.servlet.ServletContextDescriptor;
import com.amadeus.session.servlet.ServletLevel;
import java.util.EventListener;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;

class HttpSessionNotifier
implements SessionNotifier {
    private ServletContextDescriptor descriptor;

    HttpSessionNotifier(ServletContextDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void sessionCreated(RepositoryBackedSession session) {
        if (session instanceof HttpSession) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (HttpSessionListener listener : this.descriptor.getHttpSessionListeners()) {
                listener.sessionCreated(event);
            }
        }
    }

    @Override
    public void attributeAdded(RepositoryBackedSession session, String key, Object value) {
        if (session instanceof HttpSession && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)session, key));
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session, key, value);
        for (HttpSessionAttributeListener listener : this.descriptor.getHttpSessionAttributeListeners()) {
            listener.attributeAdded(event);
        }
    }

    @Override
    public void attributeReplaced(RepositoryBackedSession session, String key, Object replacedValue) {
        if (session instanceof HttpSession && replacedValue instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)replacedValue).valueUnbound(new HttpSessionBindingEvent((HttpSession)session, key));
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session, key, replacedValue);
        for (HttpSessionAttributeListener listener : this.descriptor.getHttpSessionAttributeListeners()) {
            listener.attributeReplaced(event);
        }
    }

    @Override
    public void attributeRemoved(RepositoryBackedSession session, String key, Object removedValue) {
        if (session instanceof HttpSession && removedValue instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)removedValue).valueUnbound(new HttpSessionBindingEvent((HttpSession)session, key));
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session, key);
        for (HttpSessionAttributeListener listener : this.descriptor.getHttpSessionAttributeListeners()) {
            listener.attributeRemoved(event);
        }
    }

    @Override
    public void attributeBeingStored(RepositoryBackedSession session, String key, Object value) {
        if (session instanceof HttpSession && value instanceof HttpSessionActivationListener) {
            ((HttpSessionActivationListener)value).sessionWillPassivate(new HttpSessionEvent((HttpSession)session));
        }
    }

    @Override
    public void attributeHasBeenRestored(RepositoryBackedSession session, String key, Object value) {
        if (session instanceof HttpSession && value instanceof HttpSessionActivationListener) {
            ((HttpSessionActivationListener)value).sessionDidActivate(new HttpSessionEvent((HttpSession)session));
        }
    }

    @Override
    public void sessionDestroyed(RepositoryBackedSession session, boolean shutdown) {
        block6: {
            if (!(session instanceof HttpSession)) break block6;
            for (String key : session.getAttributeNamesWithValues()) {
                HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session, key);
                for (HttpSessionAttributeListener listener : this.descriptor.getHttpSessionAttributeListeners()) {
                    listener.attributeRemoved(event);
                }
            }
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            if (shutdown) {
                List<HttpSessionListener> listeners = this.descriptor.getHttpSessionListeners();
                for (int i = listeners.size() - 1; i >= 0; --i) {
                    listeners.get(i).sessionDestroyed(event);
                }
            } else {
                for (HttpSessionListener listener : this.descriptor.getHttpSessionListeners()) {
                    listener.sessionDestroyed(event);
                }
            }
        }
    }

    @Override
    public void sessionIdChanged(RepositoryBackedSession session, String oldId) {
        if (!ServletLevel.isServlet31) {
            return;
        }
        if (session instanceof HttpSession) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (EventListener listener : this.descriptor.getHttpSessionIdListeners()) {
                ((HttpSessionIdListener)listener).sessionIdChanged(event, oldId);
            }
        }
    }
}

