/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.servlet.SessionHelpersFacade;
import com.amadeus.session.shaded.org.slf4j.Logger;
import com.amadeus.session.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class InitializeSessionManagement
implements ServletContainerInitializer {
    private static final Logger logger = LoggerFactory.getLogger(InitializeSessionManagement.class);
    private static boolean disabled = Boolean.parseBoolean(SessionConfiguration.getPropertySecured("com.amadeus.session.disabled", null));

    public void onStartup(Set<Class<?>> classes, ServletContext context) throws ServletException {
        if (disabled || Boolean.parseBoolean(context.getInitParameter("com.amadeus.session.disabled"))) {
            logger.warn("Session management disabled for {}, {}, {}", context.getContextPath(), disabled, context.getInitParameter("com.amadeus.session.disabled"));
            return;
        }
        InitializeSessionManagement.setupProviders(context);
        SessionHelpersFacade.initSessionManagement(context);
    }

    static void setupProviders(ServletContext context) {
        HashMap<String, String> providerMapping = new HashMap<String, String>();
        providerMapping.put("redis", "com.amadeus.session.repository.redis.JedisSessionRepositoryFactory");
        providerMapping.put("in-memory", "com.amadeus.session.repository.inmemory.InMemoryRepositoryFactory");
        if (logger.isDebugEnabled()) {
            logger.debug("Known session repository providers: {} for servlet context {}", (Object)providerMapping.keySet(), (Object)context.getContextPath());
        }
        context.setAttribute("com.amadeus.session.providers", providerMapping);
    }
}

