/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.servlet.ServletLevel;
import com.amadeus.session.servlet.SessionHelpers;
import com.amadeus.session.shaded.org.slf4j.Logger;
import com.amadeus.session.shaded.org.slf4j.LoggerFactory;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSessionEvent;

public final class SessionHelpersFacade {
    private static final Logger logger = LoggerFactory.getLogger(SessionHelpersFacade.class);
    private static final String DISABLED_SESSION = "com.amadeus.session.disabled";
    static boolean disabled = Boolean.parseBoolean(SessionHelpersFacade.getPropertySecured("com.amadeus.session.disabled"));

    private SessionHelpersFacade() {
    }

    public static ServletRequest prepareRequest(ServletRequest request, ServletResponse response, ServletContext filterContext) {
        return SessionHelpersFacade.helpers(SessionHelpersFacade.context(request, filterContext)).prepareRequest(request, response, filterContext);
    }

    private static ServletContext context(ServletRequest request, ServletContext context) {
        if (ServletLevel.isServlet3) {
            ServletContext sc = request.getServletContext();
            return sc == null ? context : sc;
        }
        return context;
    }

    public static ServletResponse prepareResponse(ServletRequest request, ServletResponse response, ServletContext filterContext) {
        return SessionHelpersFacade.helpers(SessionHelpersFacade.context(request, filterContext)).prepareResponse(request, response);
    }

    public static void initSessionManagement(ServletContext servletContext) {
        SessionHelpersFacade.helpers(servletContext).initSessionManagement(servletContext);
    }

    public static void commitRequest(ServletRequest request, ServletRequest oldRequest, ServletContext filterContext) {
        SessionHelpersFacade.helpers(SessionHelpersFacade.context(request, filterContext)).commitRequest(request, oldRequest);
    }

    public static void interceptHttpListener(Object listener, HttpSessionEvent event) {
        if (!(listener instanceof EventListener)) {
            logger.error("Tried registering listener {} but it was not EventListener", listener);
            return;
        }
        SessionHelpersFacade.helpers(event.getSession().getServletContext()).interceptHttpListener((EventListener)listener, event);
    }

    public static void onAddListener(Object object, Object listener) {
        if (!(object instanceof ServletContext)) {
            logger.error("Tried registering listener {} for object {} but object was not ServletContext", listener, object);
            return;
        }
        ServletContext servletContext = (ServletContext)object;
        SessionHelpersFacade.helpers(servletContext).onAddListener(servletContext, listener);
    }

    private static SessionHelpers helpers(ServletContext servletContext) {
        SessionHelpers helpers = (SessionHelpers)servletContext.getAttribute(SessionHelpers.SESSION_HELPERS);
        if (helpers == null) {
            helpers = new SessionHelpers();
        }
        return helpers;
    }

    private static String getPropertySecured(String key) {
        try {
            return System.getProperty(key, null);
        }
        catch (SecurityException e) {
            logger.info("Security exception when trying to get system property", e);
            return null;
        }
    }
}

